/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.impl.configurators;

import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurable;
import org.jenkinsci.plugins.casc.ConfigurationContext;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.model.CNode;

public class ConfigurableConfigurator<T extends Configurable>
extends Configurator<T> {
    private final Class<T> target;

    public ConfigurableConfigurator(Class<T> target) {
        this.target = target;
    }

    @Override
    public Class<T> getTarget() {
        return this.target;
    }

    @Override
    @Nonnull
    public Set<Attribute> describe() {
        return Collections.emptySet();
    }

    @Override
    @Nonnull
    public T configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
        try {
            Configurable instance = (Configurable)this.target.newInstance();
            instance.configure(config);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfiguratorException("Cannot instantiate Configurable " + this.target + " with default constructor", e);
        }
    }

    @Override
    public T check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        try {
            Configurable instance = (Configurable)this.target.newInstance();
            instance.check(config);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfiguratorException("Cannot instantiate Configurable " + this.target + " with default constructor", e);
        }
    }

    @Override
    @CheckForNull
    public CNode describe(T instance) throws Exception {
        return instance.describe();
    }
}

