/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Scalar;
import org.jenkinsci.plugins.casc.model.Sequence;
import org.kohsuke.accmod.AccessRestriction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.stapler.export.Exported;

@Restricted(value={Beta.class})
public class Attribute<Owner, Type> {
    private static final Logger logger = Logger.getLogger(Attribute.class.getName());
    protected final String name;
    protected final Class type;
    protected boolean multiple;
    protected String preferredName;
    private Setter<Owner, Type> setter;
    private Getter<Owner, Type> getter;
    private boolean deprecated;
    private Class<? extends AccessRestriction>[] restrictions;
    protected List<String> aliases;
    private static final Class[] EMPTY = new Class[0];
    public static final Setter NOOP = (target, value) -> {};

    public Attribute(String name, Class type) {
        this.name = name;
        this.type = type;
        this.getter = this::_getValue;
        this.setter = this::_setValue;
        this.aliases = new ArrayList<String>();
        this.aliases.add(name);
    }

    public String toString() {
        return String.format("%s(class: %s, multiple: %s)", this.name, this.type, this.multiple);
    }

    public String getName() {
        return this.preferredName != null ? this.preferredName : this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Class<? extends AccessRestriction>[] getRestrictions() {
        return this.restrictions != null ? this.restrictions : EMPTY;
    }

    public boolean isRestricted() {
        return this.restrictions != null && this.restrictions.length > 0;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public Attribute<Owner, Type> multiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public Attribute<Owner, Type> preferredName(String preferredName) {
        this.preferredName = preferredName;
        return this;
    }

    public Attribute<Owner, Type> setter(Setter<Owner, Type> setter) {
        this.setter = setter;
        return this;
    }

    public Attribute<Owner, Type> alias(String alias) {
        this.aliases.add(alias);
        return this;
    }

    public Attribute<Owner, Type> getter(Getter<Owner, Type> getter) {
        this.getter = getter;
        return this;
    }

    public Attribute deprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Attribute restrictions(Class<? extends AccessRestriction>[] restrictions) {
        this.restrictions = (Class[])restrictions.clone();
        return this;
    }

    public Setter<Owner, Type> getSetter() {
        return this.setter;
    }

    public Getter<Owner, Type> getGetter() {
        return this.getter;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> possibleValues() {
        if (this.type.isEnum()) {
            Class e = this.type;
            return Arrays.stream(e.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    public void setValue(Owner target, Type value) throws Exception {
        this.setter.setValue(target, value);
    }

    public Type getValue(Owner target) throws Exception {
        return this.getter.getValue(target);
    }

    public CNode describe(Owner instance) throws ConfiguratorException {
        Configurator c = Configurator.lookup(this.type);
        if (c == null) {
            return new Scalar("FAILED TO EXPORT " + instance.getClass().getName() + "#" + this.name + ": No configurator found for type " + this.type);
        }
        try {
            Object o = this.getValue(instance);
            if (o == null) {
                return null;
            }
            if (this.multiple) {
                Sequence seq = new Sequence();
                if (o.getClass().isArray()) {
                    o = Arrays.asList((Object[])o);
                }
                for (Object value : (Iterable)o) {
                    seq.add(c.describe(value));
                }
                return seq;
            }
            return c.describe(o);
        }
        catch (Exception e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            return new Scalar("FAILED TO EXPORT " + instance.getClass().getName() + "#" + this.name + ": \n" + w.toString());
        }
    }

    public boolean equals(Owner o1, Owner o2) throws Exception {
        Type v1 = this.getValue(o1);
        Type v2 = this.getValue(o2);
        if (v1 == null && v2 == null) {
            return true;
        }
        if (this.multiple) {
            // empty if block
        }
        return v1 != null && v1.equals(v2);
    }

    private Type _getValue(Owner target) throws ConfiguratorException {
        try {
            Class<?> clazz = target.getClass();
            String upname = StringUtils.capitalize((String)this.name);
            List<String> accessors = Arrays.asList("get" + upname, "is" + upname);
            for (Method method : clazz.getMethods()) {
                if (method.getParameterCount() != 0) continue;
                if (accessors.contains(method.getName())) {
                    return (Type)method.invoke(target, new Object[0]);
                }
                Exported exported = method.getAnnotation(Exported.class);
                if (exported == null || !exported.name().equalsIgnoreCase(this.name)) continue;
                return (Type)method.invoke(target, new Object[0]);
            }
            Field field = FieldUtils.getField(clazz, (String)this.name, (boolean)true);
            if (field == null) {
                throw new ConfiguratorException("Can't read attribute '" + this.name + "' from " + target);
            }
            return (Type)field.get(target);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ConfiguratorException("Can't read attribute '" + this.name + "' from " + target, e);
        }
    }

    private void _setValue(Owner target, Type value) throws Exception {
        String setterId = target.getClass().getCanonicalName() + '#' + this.name;
        Method writeMethod = null;
        for (Method method : target.getClass().getMethods()) {
            if (!method.getName().equals("set" + StringUtils.capitalize((String)this.name))) continue;
            writeMethod = method;
            break;
        }
        if (writeMethod == null) {
            throw new Exception("Default value setter cannot find Property Descriptor for " + setterId);
        }
        Object o = value;
        if (this.multiple) {
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException(setterId + " should be a list.");
            }
            Class<Set> c = writeMethod.getParameterTypes()[0];
            if (c.isArray()) {
                Collection collection = (Collection)value;
                o = collection.toArray((Object[])Array.newInstance(this.type, collection.size()));
            } else if (c.isAssignableFrom(Set.class)) {
                o = new HashSet((Collection)value);
            }
        }
        writeMethod.invoke(target, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.name, attribute.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @FunctionalInterface
    public static interface Getter<O, T> {
        public T getValue(O var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Setter<O, T> {
        public static final Setter NOP = (o, v) -> {};

        public void setValue(O var1, T var2) throws Exception;
    }
}

