/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.plugins;

import hudson.Extension;
import hudson.Plugin;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.ProxyConfiguration;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.model.DownloadService;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.impl.attributes.MultivaluedAttribute;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.jenkinsci.plugins.casc.model.Sequence;
import org.jenkinsci.plugins.casc.plugins.PluginToInstall;
import org.jenkinsci.plugins.casc.plugins.Plugins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(ordinal=999.0)
@Restricted(value={NoExternalUse.class})
public class PluginManagerConfigurator
extends BaseConfigurator<PluginManager>
implements RootElementConfigurator<PluginManager> {
    private static final Logger logger = Logger.getLogger(PluginManagerConfigurator.class.getName());

    @Override
    public Class<PluginManager> getTarget() {
        return PluginManager.class;
    }

    @Override
    public PluginManager getTargetComponent() {
        return Jenkins.getInstance().getPluginManager();
    }

    @Override
    protected PluginManager instance(Mapping mapping) {
        return this.getTargetComponent();
    }

    @Override
    public PluginManager configure(CNode config) throws ConfiguratorException {
        Mapping map = config.asMapping();
        Jenkins jenkins = Jenkins.getInstance();
        this.configureProxy(map, jenkins);
        UpdateCenter updateCenter = this.configureUpdateSites(map, jenkins);
        PluginManager pluginManager = this.configurePlugins(map, jenkins, updateCenter);
        try {
            jenkins.save();
        }
        catch (IOException e) {
            throw new ConfiguratorException("failed to save Jenkins configuration", e);
        }
        return pluginManager;
    }

    private void configureProxy(Mapping map, Jenkins jenkins) throws ConfiguratorException {
        CNode proxy = (CNode)map.get("proxy");
        if (proxy != null) {
            ProxyConfiguration pcc;
            Configurator pc = Configurator.lookup(ProxyConfiguration.class);
            if (pc == null) {
                throw new ConfiguratorException("ProxyConfiguration not well registered");
            }
            jenkins.proxy = pcc = (ProxyConfiguration)pc.configure(proxy);
        }
    }

    private UpdateCenter configureUpdateSites(Mapping map, Jenkins jenkins) throws ConfiguratorException {
        CNode sites = (CNode)map.get("sites");
        UpdateCenter updateCenter = jenkins.getUpdateCenter();
        if (sites != null) {
            Configurator usc = Configurator.lookup(UpdateSite.class);
            ArrayList<UpdateSite> updateSites = new ArrayList<UpdateSite>();
            for (CNode data : sites.asSequence()) {
                UpdateSite in = (UpdateSite)usc.configure(data);
                if (in.isDue()) {
                    in.updateDirectly(DownloadService.signatureCheck);
                }
                updateSites.add(in);
            }
            try {
                updateCenter.getSites().replaceBy(updateSites);
            }
            catch (IOException e) {
                throw new ConfiguratorException("failed to reconfigure updateCenter.sites", e);
            }
        }
        return updateCenter;
    }

    private PluginManager configurePlugins(Mapping map, Jenkins jenkins, UpdateCenter updateCenter) throws ConfiguratorException {
        LinkedList<PluginToInstall> plugins = new LinkedList<PluginToInstall>();
        CNode required = (CNode)map.get("required");
        if (required != null) {
            for (Map.Entry entry : required.asMapping().entrySet()) {
                plugins.add(new PluginToInstall((String)entry.getKey(), ((CNode)entry.getValue()).asScalar().getValue()));
            }
        }
        File shrinkwrap = this.readShrinkwrapFile(jenkins, plugins);
        PluginManager pluginManager = this.getTargetComponent();
        if (!plugins.isEmpty()) {
            logger.log(Level.CONFIG, String.format("Using plugin root dir: '%s'", pluginManager.rootDir));
            boolean requireRestart = false;
            HashSet<String> installed = new HashSet<String>();
            while (!plugins.isEmpty()) {
                PluginToInstall p = (PluginToInstall)plugins.remove();
                logger.fine("Preparing to install " + p.shortname);
                if (installed.contains(p.shortname)) {
                    logger.fine("Plugin " + p.shortname + " is already installed. Skipping");
                    continue;
                }
                Plugin plugin = jenkins.getPlugin(p.shortname);
                if (plugin != null && plugin.getWrapper().getVersion().equals(p.version)) continue;
                requireRestart |= plugin != null;
                boolean downloaded = false;
                UpdateSite.Plugin installable = this.getPluginMetadata(updateCenter, p);
                try {
                    logger.fine("Installing plugin: " + p.shortname);
                    UpdateCenter.UpdateCenterJob job = (UpdateCenter.UpdateCenterJob)installable.deploy(false).get();
                    if (job.getError() != null) {
                        if (job.getError() instanceof UpdateCenter.DownloadJob.SuccessButRequiresRestart) {
                            requireRestart = true;
                        } else {
                            throw job.getError();
                        }
                    }
                    installed.add(p.shortname);
                    File jpi = new File(pluginManager.rootDir, p.shortname + ".jpi");
                    try (JarFile jar = new JarFile(jpi);){
                        String dependencySpec = jar.getManifest().getMainAttributes().getValue("Plugin-Dependencies");
                        if (dependencySpec != null) {
                            List<PluginToInstall> pti = Arrays.stream(dependencySpec.split(",")).filter(t -> !t.endsWith(";resolution:=optional")).map(t -> t.substring(0, t.indexOf(58))).map(a -> new PluginToInstall((String)a, "latest")).collect(Collectors.toList());
                            pti.forEach(s -> logger.finest("Installing dependant plugin: " + s));
                            logger.finest("Adding " + pti.size() + " plugin(s) to install queue.");
                            plugins.addAll(pti);
                        }
                    }
                    downloaded = true;
                    continue;
                }
                catch (InterruptedException | ExecutionException ex) {
                    logger.info("Failed to download plugin " + p.shortname + ':' + p.version + " from " + p.site);
                }
                catch (Throwable ex) {
                    throw new ConfiguratorException("Failed to download plugin " + p.shortname + ':' + p.version, ex);
                }
                if (!downloaded) {
                    throw new ConfiguratorException("Failed to install plugin " + p.shortname + ':' + p.version);
                }
                logger.fine("Done installing plugins");
            }
            this.writeShrinkwrapFile(jenkins, shrinkwrap, pluginManager);
            if (requireRestart) {
                try {
                    jenkins.restart();
                }
                catch (RestartNotSupportedException e) {
                    throw new ConfiguratorException("Can't restart master after plugins installation", e);
                }
            }
        }
        return pluginManager;
    }

    private UpdateSite.Plugin getPluginMetadata(UpdateCenter updateCenter, PluginToInstall p) throws ConfiguratorException {
        UpdateSite updateSite;
        String url;
        if (!Character.isDigit(p.version.charAt(0))) {
            url = p.version;
            updateSite = updateCenter.getSite("default");
            if (updateSite == null) {
                throw new ConfiguratorException("Can't install " + p + ": no default update site");
            }
        } else {
            updateSite = updateCenter.getSite(p.site);
            if (updateSite == null) {
                throw new ConfiguratorException("Can't install " + p + ": unknown update site " + p.site);
            }
            UpdateSite.Plugin hostedPlugin = updateSite.getPlugin(p.shortname);
            if (hostedPlugin == null) {
                throw new ConfiguratorException("Can't install " + p + ": " + p.site + " does not host requested plugin");
            }
            int i = hostedPlugin.url.lastIndexOf(hostedPlugin.version);
            url = hostedPlugin.url.substring(0, i) + p.version + hostedPlugin.url.substring(i + hostedPlugin.version.length() + 1);
        }
        JSONObject json = new JSONObject();
        json.accumulate("name", (Object)p.shortname);
        json.accumulate("version", (Object)p.version);
        json.accumulate("url", (Object)url);
        json.accumulate("dependencies", (Object)new JSONArray());
        UpdateSite updateSite2 = updateSite;
        updateSite2.getClass();
        return new UpdateSite.Plugin(updateSite2, updateSite.getId(), json);
    }

    private File readShrinkwrapFile(Jenkins jenkins, Queue<PluginToInstall> plugins) throws ConfiguratorException {
        File shrinkwrap = new File(jenkins.getRootDir(), "plugins.txt");
        logger.log(Level.CONFIG, String.format("Using shrinkwrap file: '%s'", shrinkwrap.getAbsoluteFile()));
        HashMap<String, PluginToInstall> shrinkwrapped = new HashMap<String, PluginToInstall>();
        if (shrinkwrap.exists()) {
            try {
                List lines = FileUtils.readLines((File)shrinkwrap, (Charset)StandardCharsets.UTF_8);
                for (String line : lines) {
                    int i = line.indexOf(58);
                    String shortname = line.substring(0, i);
                    shrinkwrapped.put(shortname, new PluginToInstall(shortname, line.substring(i + 1)));
                }
            }
            catch (IOException e) {
                throw new ConfiguratorException("failed to load plugins.txt shrinkwrap file", e);
            }
            boolean outdated = false;
            for (PluginToInstall plugin : plugins) {
                PluginToInstall other = (PluginToInstall)shrinkwrapped.get(plugin.shortname);
                if (other != null && other.equals(plugin)) continue;
                outdated = true;
                break;
            }
            if (!outdated) {
                plugins.addAll(shrinkwrapped.values());
            }
        }
        return shrinkwrap;
    }

    private void writeShrinkwrapFile(Jenkins jenkins, File shrinkwrap, PluginManager pluginManager) throws ConfiguratorException {
        logger.fine("Writing shrinkwrap file: " + shrinkwrap);
        try (PrintWriter w = new PrintWriter(shrinkwrap, StandardCharsets.UTF_8.name());){
            for (PluginWrapper pw : pluginManager.getPlugins()) {
                if (pw.getShortName().equals("configuration-as-code")) continue;
                String from = "default";
                for (UpdateSite site : jenkins.getUpdateCenter().getSites()) {
                    if (site.getPlugin(pw.getShortName()) == null) continue;
                    from = site.getId();
                    break;
                }
                w.println(pw.getShortName() + ':' + pw.getVersionNumber().toString() + '@' + from);
            }
        }
        catch (IOException e) {
            throw new ConfiguratorException("failed to write plugins.txt shrinkwrap file", e);
        }
    }

    @Override
    public String getName() {
        return "plugins";
    }

    @Override
    public Set<Attribute> describe() {
        HashSet<Attribute> attr = new HashSet<Attribute>();
        attr.add(new Attribute("proxy", ProxyConfiguration.class));
        attr.add(new MultivaluedAttribute("sites", UpdateSite.class));
        attr.add(new MultivaluedAttribute("required", Plugins.class));
        return attr;
    }

    @Override
    @CheckForNull
    public CNode describe(PluginManager instance) throws Exception {
        Mapping mapping = new Mapping();
        Configurator cp = Configurator.lookupOrFail(ProxyConfiguration.class);
        ProxyConfiguration proxy = Jenkins.getInstance().proxy;
        if (proxy != null) {
            mapping.putIfNotNull("proxy", cp.describe(proxy));
        }
        Sequence seq = new Sequence();
        Configurator cs = Configurator.lookupOrFail(UpdateSite.class);
        for (UpdateSite site : Jenkins.getInstance().getUpdateCenter().getSiteList()) {
            seq.add(cs.describe(site));
        }
        mapping.putIfNotEmpry("sites", seq);
        return mapping;
    }
}

