/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.listeners.NodeDownstreamBuildAction;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeLogResource;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineRunImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepContainerImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueInputStep;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.RestartDeclarativePipelineAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineNodeImpl
extends BluePipelineNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineNodeImpl.class);
    private final FlowNodeWrapper node;
    private final List<BluePipelineNode.Edge> edges;
    private final Long durationInMillis;
    private final NodeRunStatus status;
    private final Link self;
    private final WorkflowRun run;
    private final Reachable parent;

    public PipelineNodeImpl(FlowNodeWrapper node, Reachable parent, WorkflowRun run) {
        this.node = node;
        this.run = run;
        this.edges = this.buildEdges(node.edges);
        this.status = node.getStatus();
        this.durationInMillis = node.getTiming().getTotalDurationMillis();
        this.self = parent.getLink().rel(node.getId());
        this.parent = parent;
    }

    public String getId() {
        return this.node.getId();
    }

    public String getDisplayName() {
        return PipelineNodeUtil.getDisplayName(this.node.getNode());
    }

    public String getDisplayDescription() {
        return null;
    }

    public BlueRun.BlueRunResult getResult() {
        return this.status.getResult();
    }

    public BlueRun.BlueRunState getStateObj() {
        return this.status.getState();
    }

    public Date getStartTime() {
        long nodeTime = this.node.getTiming().getStartTimeMillis();
        if (nodeTime == 0L) {
            return null;
        }
        return new Date(nodeTime);
    }

    public String getStartTimeString() {
        if (this.getStartTime() == null) {
            return null;
        }
        return AbstractRunImpl.DATE_FORMAT.print(this.getStartTime().getTime());
    }

    public List<BluePipelineNode.Edge> getEdges() {
        return this.edges;
    }

    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    public Object getLog() {
        return new NodeLogResource(this);
    }

    public String getType() {
        return this.node.getType().name();
    }

    public String getStepType() {
        throw new UnsupportedOperationException("not supported");
    }

    public String getCauseOfBlockage() {
        return this.node.getCauseOfFailure();
    }

    public BluePipelineStepContainer getSteps() {
        return new PipelineStepContainerImpl(this.node, this.self, this.run);
    }

    public Link getLink() {
        return this.self;
    }

    public Collection<BlueActionProxy> getActions() {
        HashSet<NodeDownstreamBuildAction> actions = new HashSet<NodeDownstreamBuildAction>();
        actions.addAll(this.node.getNode().getActions());
        actions.addAll(this.node.getPipelineActions(NodeDownstreamBuildAction.class));
        return ActionProxiesImpl.getActionProxies(actions, input -> input instanceof LogAction || input instanceof NodeDownstreamBuildAction, (Reachable)this);
    }

    public boolean isRestartable() {
        List restartableStages;
        RestartDeclarativePipelineAction restartDeclarativePipelineAction = (RestartDeclarativePipelineAction)this.run.getAction(RestartDeclarativePipelineAction.class);
        if (restartDeclarativePipelineAction != null && (restartableStages = restartDeclarativePipelineAction.getRestartableStages()) != null) {
            return restartableStages.contains(this.getDisplayName()) && this.getStateObj() == BlueRun.BlueRunState.FINISHED;
        }
        return false;
    }

    public BlueInputStep getInputStep() {
        return null;
    }

    public HttpResponse submitInputStep(StaplerRequest request) {
        return null;
    }

    public HttpResponse restart(StaplerRequest request) {
        try {
            JSONObject body = JSONObject.fromObject((Object)IOUtils.toString((Reader)request.getReader()));
            boolean restart = body.getBoolean("restart");
            if (restart && this.isRestartable()) {
                LOGGER.debug("submitInputStep, restart: {}, step: {}", (Object)restart, (Object)this.getDisplayName());
                RestartDeclarativePipelineAction restartDeclarativePipelineAction = (RestartDeclarativePipelineAction)this.run.getAction(RestartDeclarativePipelineAction.class);
                Queue.Item item = restartDeclarativePipelineAction.run(this.getDisplayName());
                BluePipeline bluePipeline = BluePipelineFactory.getPipelineInstance((Item)this.run.getParent(), (Reachable)this.parent);
                BlueQueueItem queueItem = QueueUtil.getQueuedItem((BlueOrganization)bluePipeline.getOrganization(), (Queue.Item)item, (Job)this.run.getParent());
                if (queueItem != null) {
                    return (req, rsp, node1) -> {
                        rsp.setStatus(200);
                        rsp.getOutputStream().print(Export.toJson((Object)queueItem.toRun()));
                    };
                }
                WorkflowRun restartRun = (WorkflowRun)QueueUtil.getRun((Job)this.run.getParent(), (long)item.getId());
                if (restartRun != null) {
                    return (req, rsp, node1) -> {
                        rsp.setStatus(200);
                        rsp.getOutputStream().print(Export.toJson((Object)((Object)new PipelineRunImpl(restartRun, this.parent, bluePipeline.getOrganization()))));
                    };
                }
                throw new ServiceException.UnexpectedErrorException("Run was not added to queue.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("error restarting stage: " + e.getMessage(), (Throwable)e);
            throw new ServiceException.UnexpectedErrorException(e.getMessage());
        }
        return null;
    }

    private List<BluePipelineNode.Edge> buildEdges(List<FlowNodeWrapper> nodes) {
        ArrayList<BluePipelineNode.Edge> edges = new ArrayList<BluePipelineNode.Edge>();
        if (!nodes.isEmpty()) {
            for (FlowNodeWrapper edge : nodes) {
                edges.add(new EdgeImpl(edge));
            }
        }
        return edges;
    }

    FlowNodeWrapper getFlowNodeWrapper() {
        return this.node;
    }

    public static class EdgeImpl
    extends BluePipelineNode.Edge {
        private final String id;
        private final String type;

        public EdgeImpl(FlowNodeWrapper edge) {
            this.id = edge.getId();
            this.type = edge.getType().name();
        }

        public String getId() {
            return this.id;
        }

        @Exported
        public String getType() {
            return this.type;
        }
    }
}

