/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.preload;

import com.google.common.collect.Iterables;
import hudson.Extension;
import hudson.model.User;
import io.jenkins.blueocean.commons.BlueUrlTokenizer;
import io.jenkins.blueocean.commons.RESTFetchPreloader;
import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueFavoriteContainer;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Extension
public class FavoritesStatePreloader
extends RESTFetchPreloader {
    private static final Logger LOGGER = Logger.getLogger(FavoritesStatePreloader.class.getName());
    private static final int DEFAULT_LIMIT = 26;

    protected RESTFetchPreloader.FetchData getFetchData(@Nonnull BlueUrlTokenizer blueUrl) {
        BlueOrganization organization;
        User jenkinsUser = User.current();
        if (jenkinsUser != null && (organization = (BlueOrganization)Iterables.getFirst((Iterable)OrganizationFactory.getInstance().list(), null)) != null) {
            String pipelineFullName = blueUrl.getPart(BlueUrlTokenizer.UrlPart.PIPELINE);
            if (pipelineFullName != null) {
                return null;
            }
            UserImpl blueUser = new UserImpl(organization, jenkinsUser, (Reachable)organization.getUsers());
            BlueFavoriteContainer favoritesContainer = blueUser.getFavorites();
            if (favoritesContainer != null) {
                JSONArray favorites = new JSONArray();
                Iterator favoritesIterator = favoritesContainer.iterator(0, 26);
                while (favoritesIterator.hasNext()) {
                    Reachable favorite = (Reachable)favoritesIterator.next();
                    try {
                        favorites.add((Object)JSONObject.fromObject((Object)Export.toJson((Object)favorite)));
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, String.format("Unable to preload favorites for User '%s'. Serialization error.", jenkinsUser.getFullName()), e);
                        return null;
                    }
                }
                return new RESTFetchPreloader.FetchData(favoritesContainer.getLink().getHref() + "?start=0&limit=" + 26, favorites.toString());
            }
        }
        return null;
    }
}

