/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.scm;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class ScmFactory
implements ExtensionPoint {
    @CheckForNull
    public abstract Scm getScm(@Nonnull String var1, @Nonnull Reachable var2);

    @Nonnull
    public abstract Scm getScm(Reachable var1);

    @CheckForNull
    public static Scm resolve(@Nonnull String id, @Nonnull Reachable parent) {
        for (ScmFactory scmFactory : ScmFactory.all()) {
            Scm scm = scmFactory.getScm(id, parent);
            if (scm == null) continue;
            return scm;
        }
        return null;
    }

    @Nonnull
    public static List<Scm> resolve(@Nonnull Reachable parent) {
        ArrayList<Scm> scms = new ArrayList<Scm>();
        for (ScmFactory scmFactory : ScmFactory.all()) {
            scms.add(scmFactory.getScm(parent));
        }
        return scms;
    }

    public static ExtensionList<ScmFactory> all() {
        return ExtensionList.lookup(ScmFactory.class);
    }
}

