/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.model.Result;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.NodeGraphBuilder;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineNodeContainerImpl
extends BluePipelineNodeContainer {
    private final WorkflowRun run;
    private final Map<String, BluePipelineNode> nodeMap = new HashMap<String, BluePipelineNode>();
    private final List<BluePipelineNode> nodes;
    private final Link self;

    public PipelineNodeContainerImpl(WorkflowRun run, Link parentLink) {
        this.run = run;
        this.self = parentLink.rel("nodes");
        WorkflowJob job = (WorkflowJob)run.getParent();
        NodeGraphBuilder graphBuilder = NodeGraphBuilder.NodeGraphBuilderFactory.getInstance(run);
        if (run.getResult() != Result.SUCCESS && job.getLastSuccessfulBuild() != null && Integer.parseInt(((WorkflowRun)job.getLastSuccessfulBuild()).getId()) < Integer.parseInt(run.getId())) {
            NodeGraphBuilder pastBuildGraph = NodeGraphBuilder.NodeGraphBuilderFactory.getInstance((WorkflowRun)job.getLastSuccessfulBuild());
            this.nodes = graphBuilder.union(pastBuildGraph.getPipelineNodes(), this.getLink());
        } else {
            this.nodes = graphBuilder.getPipelineNodes(this.getLink());
        }
        for (BluePipelineNode node : this.nodes) {
            this.nodeMap.put(node.getId(), node);
        }
    }

    public BluePipelineNode get(String name) {
        if (this.nodeMap.get(name) != null) {
            return this.nodeMap.get(name);
        }
        throw new ServiceException.NotFoundException(String.format("Stage %s not found in pipeline %s.", name, ((WorkflowJob)this.run.getParent()).getName()));
    }

    public Iterator<BluePipelineNode> iterator() {
        return this.nodes.iterator();
    }

    public Link getLink() {
        return this.self;
    }

    protected List<BluePipelineNode> getNodes() {
        return this.nodes;
    }
}

