/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.geom;

final class MathUtils {
    private static final long POSITIVE_ZERO_BITS = Double.doubleToRawLongBits(0.0);
    private static final long NEGATIVE_ZERO_BITS = Double.doubleToRawLongBits(-0.0);

    private MathUtils() {
    }

    static boolean equal(double x, double y, int ulps) {
        boolean equal;
        long b;
        long a = Double.doubleToRawLongBits(x);
        if (a < (b = Double.doubleToRawLongBits(y))) {
            long t = a;
            a = b;
            b = t;
        }
        if ((a ^ b) < 0L) {
            long diffPositive = a - POSITIVE_ZERO_BITS;
            long diffNegative = b - NEGATIVE_ZERO_BITS;
            equal = diffPositive <= (long)ulps && diffNegative <= (long)ulps - diffPositive;
        } else {
            equal = a - b <= (long)ulps;
        }
        return equal && !Double.isNaN(x) && !Double.isNaN(y);
    }
}

