/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.geom;

import io.jenetics.jpx.Length;
import io.jenetics.jpx.Point;
import io.jenetics.jpx.geom.Ellipsoid;
import io.jenetics.jpx.geom.LengthCollector;
import io.jenetics.jpx.geom.MathUtils;
import java.util.Objects;
import java.util.stream.Collector;

public final class Geoid {
    private static final int EPSILON_ULP = 10000;
    public static final Geoid WGS84 = Geoid.of(Ellipsoid.WGS84);
    public static final Geoid IERS_1989 = Geoid.of(Ellipsoid.IERS_1989);
    public static final Geoid IERS_2003 = Geoid.of(Ellipsoid.IERS_2003);
    public static final Geoid DEFAULT = Geoid.of(Ellipsoid.DEFAULT);
    private final Ellipsoid _ellipsoid;
    private final double B;
    private final double AABBBB;
    private final double F;
    private static final int DISTANCE_ITERATION_MAX = 1000;
    private static final double DISTANCE_ITERATION_EPSILON = 1.0E-12;

    private Geoid(Ellipsoid ellipsoid) {
        this._ellipsoid = Objects.requireNonNull(ellipsoid);
        double a = ellipsoid.A();
        double aa = a * a;
        this.B = ellipsoid.B();
        double bb = this.B * this.B;
        this.AABBBB = (aa - bb) / bb;
        this.F = 1.0 / ellipsoid.F();
    }

    public Ellipsoid ellipsoid() {
        return this._ellipsoid;
    }

    public Length distance(Point start, Point end) {
        double deltasigma;
        double a;
        double sigma;
        double lambda0;
        double lat1 = start.getLatitude().toRadians();
        double lon1 = start.getLongitude().toRadians();
        double lat2 = end.getLatitude().toRadians();
        double lon2 = end.getLongitude().toRadians();
        double omega = lon2 - lon1;
        double tanphi1 = Math.tan(lat1);
        double tanU1 = (1.0 - this.F) * tanphi1;
        double U1 = Math.atan(tanU1);
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double tanphi2 = Math.tan(lat2);
        double tanU2 = (1.0 - this.F) * tanphi2;
        double U2 = Math.atan(tanU2);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double sinU1sinU2 = sinU1 * sinU2;
        double cosU1sinU2 = cosU1 * sinU2;
        double sinU1cosU2 = sinU1 * cosU2;
        double cosU1cosU2 = cosU1 * cosU2;
        double lambda = omega;
        int iteration = 0;
        do {
            lambda0 = lambda;
            double sinlambda = Math.sin(lambda);
            double coslambda = Math.cos(lambda);
            double sin2sigma = cosU2 * sinlambda * cosU2 * sinlambda + (cosU1sinU2 - sinU1cosU2 * coslambda) * (cosU1sinU2 - sinU1cosU2 * coslambda);
            double sinsigma = Math.sqrt(sin2sigma);
            double cossigma = sinU1sinU2 + cosU1cosU2 * coslambda;
            sigma = Math.atan2(sinsigma, cossigma);
            double sinalpha = MathUtils.equal(sin2sigma, 0.0, 10000) ? 0.0 : cosU1cosU2 * sinlambda / sinsigma;
            double alpha = Math.asin(sinalpha);
            double cosalpha = Math.cos(alpha);
            double cos2alpha = cosalpha * cosalpha;
            double cos2sigmam = MathUtils.equal(cos2alpha, 0.0, 10000) ? 0.0 : cossigma - 2.0 * sinU1sinU2 / cos2alpha;
            double u2 = cos2alpha * this.AABBBB;
            double cos2sigmam2 = cos2sigmam * cos2sigmam;
            a = 1.0 + u2 / 16384.0 * (4096.0 + u2 * (-768.0 + u2 * (320.0 - 175.0 * u2)));
            double b = u2 / 1024.0 * (256.0 + u2 * (-128.0 + u2 * (74.0 - 47.0 * u2)));
            deltasigma = b * sinsigma * (cos2sigmam + b / 4.0 * (cossigma * (-1.0 + 2.0 * cos2sigmam2) - b / 6.0 * cos2sigmam * (-3.0 + 4.0 * sin2sigma) * (-3.0 + 4.0 * cos2sigmam2)));
            double C = this.F / 16.0 * cos2alpha * (4.0 + this.F * (4.0 - 3.0 * cos2alpha));
            lambda = omega + (1.0 - C) * this.F * sinalpha * (sigma + C * sinsigma * (cos2sigmam + C * cossigma * (-1.0 + 2.0 * cos2sigmam2)));
        } while (iteration++ < 1000 && Math.abs((lambda - lambda0) / lambda) > 1.0E-12);
        if (iteration >= 1000) {
            throw new ArithmeticException(String.format("Calculating distance between %s and %s didn't converge.", start, end));
        }
        double s = this.B * a * (sigma - deltasigma);
        return Length.of(s, Length.Unit.METER);
    }

    public Collector<Point, ?, Length> toPathLength() {
        return Collector.of(() -> new LengthCollector(this), LengthCollector::add, LengthCollector::combine, LengthCollector::pathLength, new Collector.Characteristics[0]);
    }

    public Collector<Point, ?, Length> toTourLength() {
        return Collector.of(() -> new LengthCollector(this), LengthCollector::add, LengthCollector::combine, LengthCollector::tourLength, new Collector.Characteristics[0]);
    }

    public static Geoid of(Ellipsoid ellipsoid) {
        return new Geoid(ellipsoid);
    }
}

