/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.geom;

import java.io.Serializable;
import java.util.Objects;

public final class Ellipsoid
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Ellipsoid WGS84 = Ellipsoid.of("WGS-84", 6378137.0, 6356752.314245, 298.257223563);
    public static final Ellipsoid IERS_1989 = Ellipsoid.of("IERS-1989", 6378136.0, 6356751.302, 298.257);
    public static final Ellipsoid IERS_2003 = Ellipsoid.of("IERS-2003", 6378136.6, 6356751.9, 298.25642);
    public static final Ellipsoid DEFAULT = WGS84;
    private final String _name;
    private final double _a;
    private final double _b;
    private final double _f;

    private Ellipsoid(String name, double a, double b, double f) {
        this._name = Objects.requireNonNull(name);
        this._a = a;
        this._b = b;
        this._f = f;
    }

    public String getName() {
        return this._name;
    }

    public double A() {
        return this._a;
    }

    public double B() {
        return this._b;
    }

    public double F() {
        return this._f;
    }

    public static Ellipsoid of(String name, double a, double b, double f) {
        return new Ellipsoid(name, a, b, f);
    }
}

