/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.format;

import io.jenetics.jpx.format.Format;
import io.jenetics.jpx.format.Location;
import io.jenetics.jpx.format.LocationBuilder;
import io.jenetics.jpx.format.ParseException;
import java.text.ParsePosition;
import java.util.Optional;

enum Plus implements Format
{
    INSTANCE;


    @Override
    public Optional<String> format(Location value) {
        return Optional.of("+");
    }

    @Override
    public void parse(CharSequence in, ParsePosition pos, LocationBuilder builder) {
        int i = pos.getIndex();
        if (in.length() <= i) {
            pos.setErrorIndex(i);
            throw new ParseException("Cannot parse +", in, i);
        }
        char c = in.charAt(i);
        if (c != '+') {
            pos.setErrorIndex(i);
            throw new ParseException("Wanted +, found " + c, in, i);
        }
        pos.setIndex(i + 1);
    }

    @Override
    public String toPattern() {
        return "+";
    }
}

