/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.format;

import io.jenetics.jpx.Latitude;
import io.jenetics.jpx.Length;
import io.jenetics.jpx.Longitude;
import io.jenetics.jpx.format.ConstFormat;
import io.jenetics.jpx.format.Elevation;
import io.jenetics.jpx.format.Field;
import io.jenetics.jpx.format.Format;
import io.jenetics.jpx.format.FormatterException;
import io.jenetics.jpx.format.LatitudeDegree;
import io.jenetics.jpx.format.LatitudeMinute;
import io.jenetics.jpx.format.LatitudeNS;
import io.jenetics.jpx.format.LatitudeSecond;
import io.jenetics.jpx.format.Location;
import io.jenetics.jpx.format.LocationBuilder;
import io.jenetics.jpx.format.LongitudeDegree;
import io.jenetics.jpx.format.LongitudeEW;
import io.jenetics.jpx.format.LongitudeMinute;
import io.jenetics.jpx.format.LongitudeSecond;
import io.jenetics.jpx.format.OptionalFormat;
import io.jenetics.jpx.format.ParseException;
import io.jenetics.jpx.format.Plus;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class LocationFormatter {
    static final Set<Character> PROTECTED_CHARS = Set.of(Character.valueOf('L'), Character.valueOf('D'), Character.valueOf('M'), Character.valueOf('S'), Character.valueOf('l'), Character.valueOf('d'), Character.valueOf('m'), Character.valueOf('s'), Character.valueOf('E'), Character.valueOf('H'), Character.valueOf('X'), Character.valueOf('x'), Character.valueOf('+'), Character.valueOf('['), Character.valueOf(']'));
    public static final LocationFormatter ISO_HUMAN_LAT_LONG = LocationFormatter.ofPattern("D\u00b0MM''SS.SSS\"X");
    public static final LocationFormatter ISO_HUMAN_LON_LONG = LocationFormatter.ofPattern("d\u00b0mm''ss.sss\"x");
    public static final LocationFormatter ISO_HUMAN_ELE_LONG = LocationFormatter.ofPattern("E.EE'm'");
    public static final LocationFormatter ISO_HUMAN_LONG = LocationFormatter.ofPattern("D\u00b0MM''SS.SSS\"X d\u00b0mm''ss.sss\"x[ E.EE'm']");
    public static final LocationFormatter ISO_LAT_SHORT = LocationFormatter.ofPattern("+DD.DD");
    public static final LocationFormatter ISO_LAT_MEDIUM = LocationFormatter.ofPattern("+DDMM.MMM");
    public static final LocationFormatter ISO_LAT_LONG = LocationFormatter.ofPattern("+DDMMSS.SS");
    public static final LocationFormatter ISO_LON_SHORT = LocationFormatter.ofPattern("+ddd.dd");
    public static final LocationFormatter ISO_LON_MEDIUM = LocationFormatter.ofPattern("+dddmm.mmm");
    public static final LocationFormatter ISO_LON_LONG = LocationFormatter.ofPattern("+dddmmss.ss");
    public static final LocationFormatter ISO_ELE_SHORT = LocationFormatter.ofPattern("+E'CRS'");
    public static final LocationFormatter ISO_ELE_MEDIUM = LocationFormatter.ofPattern("+E.E'CRS'");
    public static final LocationFormatter ISO_ELE_LONG = LocationFormatter.ofPattern("+E.EE'CRS'");
    public static final LocationFormatter ISO_SHORT = LocationFormatter.ofPattern("+DD.DD+ddd.dd[+E'CRS']");
    public static final LocationFormatter ISO_MEDIUM = LocationFormatter.ofPattern("+DDMM.MMM+dddmm.mmm[+E.E'CRS']");
    public static final LocationFormatter ISO_LONG = LocationFormatter.ofPattern("+DDMMSS.SS+dddmmss.ss[+E.EE'CRS']");
    private final List<Format> _formats;

    private LocationFormatter(List<Format> formats) {
        this._formats = List.copyOf(formats);
    }

    public String format(Location location) {
        Objects.requireNonNull(location);
        return this._formats.stream().map(format -> format.format(location).orElseThrow(() -> this.toError(location))).collect(Collectors.joining());
    }

    private FormatterException toError(Location location) {
        return new FormatterException(String.format("Invalid format '%s' for location %s.", this.toPattern(), location));
    }

    public String toPattern() {
        return this._formats.stream().map(Format::toPattern).collect(Collectors.joining());
    }

    public String format(Latitude lat, Longitude lon, Length ele) {
        return this.format(Location.of(lat, lon, ele));
    }

    public String format(Latitude lat, Longitude lon) {
        return this.format(lat, lon, null);
    }

    public String format(Latitude lat) {
        return this.format(lat, null, null);
    }

    public String format(Longitude lon) {
        return this.format(null, lon, null);
    }

    public String format(Length ele) {
        return this.format(null, null, ele);
    }

    public Location parse(CharSequence text, ParsePosition pos) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(pos);
        if (pos.getIndex() < 0 || text.length() <= pos.getIndex()) {
            throw new IndexOutOfBoundsException(pos.getIndex());
        }
        LocationBuilder builder = new LocationBuilder();
        for (Format format : this._formats) {
            format.parse(text, pos, builder);
        }
        return builder.build();
    }

    public Location parse(CharSequence text) {
        Objects.requireNonNull(text);
        ParsePosition pos = new ParsePosition(0);
        Location location = this.parse(text, pos);
        if (pos.getIndex() != text.length()) {
            throw new ParseException("Not all input used", text, pos.getIndex());
        }
        return location;
    }

    public String toString() {
        return String.format("LocationFormat[%s]", this.toPattern());
    }

    public static LocationFormatter ofPattern(String pattern) {
        Objects.requireNonNull(pattern);
        return new Builder().appendPattern(pattern).build();
    }

    static class Builder {
        private final List<Format> _formats = new ArrayList<Format>();

        private Builder() {
        }

        Builder appendPattern(String pattern) {
            this.parsePattern(pattern);
            return this;
        }

        LocationFormatter build() {
            this.validate();
            return new LocationFormatter(this._formats);
        }

        private void validate() {
            Field D = null;
            Field M = null;
            LatitudeSecond S = null;
            LatitudeNS X = null;
            Field d = null;
            Field m = null;
            LongitudeSecond s = null;
            LongitudeEW x = null;
            Elevation E = null;
            for (Format format : this._formats) {
                if (format instanceof LatitudeDegree) {
                    LatitudeDegree ld = (LatitudeDegree)format;
                    if (D == null) {
                        D = ld;
                        continue;
                    }
                    throw Builder.iae("Only one 'D' pattern allowed.");
                }
                if (format instanceof LatitudeMinute) {
                    LatitudeMinute lm = (LatitudeMinute)format;
                    if (M == null) {
                        M = lm;
                        continue;
                    }
                    throw Builder.iae("Only one 'M' pattern allowed.");
                }
                if (format instanceof LatitudeSecond) {
                    LatitudeSecond ls = (LatitudeSecond)format;
                    if (S == null) {
                        S = ls;
                        continue;
                    }
                    throw Builder.iae("Only one 'S' pattern allowed.");
                }
                if (format instanceof LatitudeNS && X == null) {
                    X = (LatitudeNS)format;
                    continue;
                }
                if (format instanceof LongitudeDegree) {
                    LongitudeDegree ld = (LongitudeDegree)format;
                    if (d == null) {
                        d = ld;
                        continue;
                    }
                    throw Builder.iae("Only one 'd' pattern allowed.");
                }
                if (format instanceof LongitudeMinute) {
                    LongitudeMinute lm = (LongitudeMinute)format;
                    if (m == null) {
                        m = lm;
                        continue;
                    }
                    throw Builder.iae("Only one 'm' pattern allowed.");
                }
                if (format instanceof LongitudeSecond) {
                    LongitudeSecond ls = (LongitudeSecond)format;
                    if (s == null) {
                        s = ls;
                        continue;
                    }
                    throw Builder.iae("Only one 's' pattern allowed.");
                }
                if (format instanceof LongitudeEW) {
                    LongitudeEW lew = (LongitudeEW)format;
                    if (x == null) {
                        x = lew;
                        continue;
                    }
                }
                if (!(format instanceof Elevation)) continue;
                Elevation ele = (Elevation)format;
                if (E == null) {
                    E = ele;
                    continue;
                }
                throw Builder.iae("Only one 'E' pattern allowed.");
            }
            if (D == null && M != null) {
                throw Builder.iae("No 'M' without 'D'.");
            }
            if (M == null && S != null) {
                throw Builder.iae("No 'S' without 'M'.");
            }
            if (X != null && D != null && D.isPrefixSign()) {
                throw Builder.iae("If 'X' in pattern, 'D' must be without '+'.");
            }
            if (D != null && 0 < D.getMinimumFractionDigits() && M != null) {
                throw Builder.iae("If 'D' has fraction, no 'M' or 'S' allowed.");
            }
            if (M != null && 0 < M.getMinimumFractionDigits() && S != null) {
                throw Builder.iae("If 'M' has fraction, no 'S' allowed.");
            }
            if (d == null && m != null) {
                throw Builder.iae("No 'm' without 'd'.");
            }
            if (m == null && s != null) {
                throw Builder.iae("No 's' without 'm'.");
            }
            if (x != null && d != null && d.isPrefixSign()) {
                throw Builder.iae("If 'x' in pattern, 'd' must be without '+'.");
            }
            if (d != null && 0 < d.getMinimumFractionDigits() && m != null) {
                throw Builder.iae("If 'd' has fraction, no 'm' or 's' allowed.");
            }
            if (m != null && 0 < m.getMinimumFractionDigits() && s != null) {
                throw Builder.iae("If 'm' has fraction, no 's' allowed.");
            }
            if (X != null && D != null) {
                D.setAbsolute(true);
            }
            if (M != null) {
                D.setTruncate(true);
            }
            if (S != null) {
                M.setTruncate(true);
            }
            if (x != null && d != null) {
                d.setAbsolute(true);
            }
            if (m != null) {
                d.setTruncate(true);
            }
            if (s != null) {
                m.setTruncate(true);
            }
        }

        private static IllegalArgumentException iae(String message) {
            return new IllegalArgumentException(message);
        }

        private void parsePattern(String pattern) {
            Objects.requireNonNull(pattern);
            ArrayList<Format> formats = new ArrayList<Format>();
            boolean optional = false;
            int signs = 0;
            boolean quote = false;
            Tokens tokens = new Tokens(Builder.tokenize(pattern));
            while (tokens.hasNext()) {
                String token;
                switch (token = tokens.next()) {
                    case "X": {
                        List<Object> fs = optional ? formats : this._formats;
                        for (int i = 0; i < signs; ++i) {
                            fs.add(Plus.INSTANCE);
                        }
                        signs = 0;
                        fs.add(LatitudeNS.INSTANCE);
                        break;
                    }
                    case "x": {
                        List<Object> fs = optional ? formats : this._formats;
                        for (int i = 0; i < signs; ++i) {
                            fs.add(Plus.INSTANCE);
                        }
                        signs = 0;
                        fs.add(LongitudeEW.INSTANCE);
                        break;
                    }
                    case "+": {
                        ++signs;
                        break;
                    }
                    case "[": {
                        if (optional) {
                            throw Builder.iae("No nesting '[' (optional) allowed.");
                        }
                        for (int i = 0; i < signs; ++i) {
                            this._formats.add(Plus.INSTANCE);
                        }
                        signs = 0;
                        optional = true;
                        break;
                    }
                    case "]": {
                        if (!optional) {
                            throw Builder.iae("Missing open '[' bracket.");
                        }
                        for (int i = 0; i < signs; ++i) {
                            formats.add(Plus.INSTANCE);
                        }
                        signs = 0;
                        optional = false;
                        this._formats.add(OptionalFormat.of(formats));
                        formats.clear();
                        break;
                    }
                    case "'": {
                        List<Object> fs = optional ? formats : this._formats;
                        for (int i = 0; i < signs; ++i) {
                            fs.add(Plus.INSTANCE);
                        }
                        if (tokens.after().filter("'"::equals).isPresent()) {
                            fs.add(ConstFormat.of("'"));
                            tokens.next();
                            break;
                        }
                        if (quote) {
                            if (tokens.before().isPresent()) {
                                fs.add(ConstFormat.of(tokens.before().orElseThrow(AssertionError::new)));
                            }
                            quote = false;
                            break;
                        }
                        quote = true;
                        break;
                    }
                    default: {
                        List<Format> fs;
                        List<Format> list = fs = optional ? formats : this._formats;
                        if (!quote) {
                            Optional<Field> field = Field.ofPattern(token);
                            if (field.isPresent()) {
                                Field f = field.get();
                                if (0 < signs) {
                                    f.setPrefixSign(true);
                                    for (int i = 1; i < signs; ++i) {
                                        fs.add(Plus.INSTANCE);
                                    }
                                }
                                fs.add(f);
                            } else {
                                fs.add(ConstFormat.of(token));
                            }
                        }
                        signs = 0;
                    }
                }
            }
            for (int i = 0; i < signs; ++i) {
                formats.add(Plus.INSTANCE);
            }
            if (optional) {
                throw Builder.iae("No closing ']' found.");
            }
            if (quote) {
                throw Builder.iae("Missing closing ' character.");
            }
            this._formats.addAll(formats);
        }

        static List<String> tokenize(String pattern) {
            ArrayList<String> tokens = new ArrayList<String>();
            StringBuilder token = new StringBuilder();
            boolean quote = false;
            char pc = '\u0000';
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                switch (c) {
                    case '\'': {
                        boolean bl = quote = !quote;
                        if (!token.isEmpty()) {
                            tokens.add(token.toString());
                            token.setLength(0);
                        }
                        tokens.add(Character.toString(c));
                        break;
                    }
                    case '+': 
                    case 'X': 
                    case '[': 
                    case ']': 
                    case 'x': {
                        if (quote) {
                            token.append(c);
                            break;
                        }
                        if (!token.isEmpty()) {
                            tokens.add(token.toString());
                            token.setLength(0);
                        }
                        tokens.add(Character.toString(c));
                        break;
                    }
                    case 'D': 
                    case 'E': 
                    case 'H': 
                    case 'L': 
                    case 'M': 
                    case 'S': 
                    case 'd': 
                    case 'l': 
                    case 'm': 
                    case 's': {
                        if (c != pc && pc != '\u0000' && pc != '.' && pc != ',' && !quote && !token.isEmpty()) {
                            tokens.add(token.toString());
                            token.setLength(0);
                        }
                        token.append(c);
                        break;
                    }
                    case ',': 
                    case '.': {
                        token.append(c);
                        break;
                    }
                    default: {
                        if ((PROTECTED_CHARS.contains(Character.valueOf(pc)) || pc == '\'') && !token.isEmpty()) {
                            tokens.add(token.toString());
                            token.setLength(0);
                        }
                        token.append(c);
                    }
                }
                pc = c;
            }
            if (!token.isEmpty()) {
                tokens.add(token.toString());
            }
            return tokens;
        }
    }

    private static final class Tokens
    implements Iterator<String> {
        private final List<String> _tokens;
        private int _index = 0;

        private Tokens(List<String> tokens) {
            this._tokens = List.copyOf(tokens);
        }

        @Override
        public boolean hasNext() {
            return this._index < this._tokens.size();
        }

        @Override
        public String next() {
            return this._tokens.get(this._index++);
        }

        Optional<String> before() {
            return this._index - 1 > 0 ? Optional.of(this._tokens.get(this._index - 2)) : Optional.empty();
        }

        Optional<String> after() {
            return this.hasNext() ? Optional.of(this._tokens.get(this._index)) : Optional.empty();
        }
    }
}

