/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.format;

import io.jenetics.jpx.Latitude;
import io.jenetics.jpx.Length;
import io.jenetics.jpx.Longitude;
import io.jenetics.jpx.format.Location;

final class LocationBuilder {
    private Double _latitude = null;
    private int _latitudeSign = 1;
    private Double _longitude = null;
    private int _longitudeSign = 1;
    private Double elevation = null;

    LocationBuilder() {
    }

    LocationBuilder copy() {
        LocationBuilder c = new LocationBuilder();
        c._latitudeSign = this._latitudeSign;
        c._latitude = this._latitude;
        c._longitudeSign = this._longitudeSign;
        c._longitude = this._longitude;
        c.elevation = this.elevation;
        return c;
    }

    void copy(LocationBuilder from) {
        this._latitudeSign = from._latitudeSign;
        this._latitude = from._latitude;
        this._longitudeSign = from._longitudeSign;
        this._longitude = from._longitude;
        this.elevation = from.elevation;
    }

    void setLatitudeSign(int sign) {
        this._latitudeSign = sign;
    }

    void addLatitude(double degrees) {
        if (degrees < 0.0) {
            this._latitudeSign = -1;
        }
        if (this._latitude == null) {
            this._latitude = 0.0;
        }
        this._latitude = this._latitude + Math.abs(degrees);
    }

    void addLatitudeMinute(double minutes) {
        this.addLatitude(minutes / 60.0);
    }

    void addLatitudeSecond(double seconds) {
        this.addLatitude(seconds / 3600.0);
    }

    void setLongitudeSign(int sign) {
        this._longitudeSign = sign;
    }

    void addLongitude(double degrees) {
        if (degrees < 0.0) {
            this._longitudeSign = -1;
        }
        if (this._longitude == null) {
            this._longitude = 0.0;
        }
        this._longitude = this._longitude + Math.abs(degrees);
    }

    void addLongitudeMinute(double minutes) {
        this.addLongitude(minutes / 60.0);
    }

    void addLongitudeSecond(double seconds) {
        this.addLongitude(seconds / 3600.0);
    }

    void setElevation(double meters) {
        this.elevation = meters;
    }

    Location build() {
        Latitude lat = this._latitude == null ? null : Latitude.ofDegrees((double)this._latitudeSign * this._latitude);
        Longitude lon = this._longitude == null ? null : Longitude.ofDegrees((double)this._longitudeSign * this._longitude);
        Length ele = this.elevation == null ? null : Length.of(this.elevation, Length.Unit.METER);
        return Location.of(lat, lon, ele);
    }
}

