/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.format;

import io.jenetics.jpx.Latitude;
import io.jenetics.jpx.format.Format;
import io.jenetics.jpx.format.Location;
import io.jenetics.jpx.format.LocationBuilder;
import io.jenetics.jpx.format.ParseException;
import java.text.ParsePosition;
import java.util.Optional;

enum LatitudeNS implements Format
{
    INSTANCE;


    @Override
    public Optional<String> format(Location value) {
        return value.latitude().map(Latitude::toDegrees).map(v -> Double.compare(v, 0.0) >= 0 ? "N" : "S");
    }

    @Override
    public void parse(CharSequence in, ParsePosition pos, LocationBuilder builder) {
        int i = pos.getIndex();
        switch (in.charAt(i)) {
            case 'N': {
                pos.setIndex(i + 1);
                builder.setLatitudeSign(1);
                break;
            }
            case 'S': {
                pos.setIndex(i + 1);
                builder.setLatitudeSign(-1);
                break;
            }
            default: {
                pos.setErrorIndex(i);
                throw new ParseException("Not found N/S", in, i);
            }
        }
    }

    @Override
    public String toPattern() {
        return "X";
    }
}

