/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.format;

import io.jenetics.jpx.format.Elevation;
import io.jenetics.jpx.format.Format;
import io.jenetics.jpx.format.LatitudeDegree;
import io.jenetics.jpx.format.LatitudeMinute;
import io.jenetics.jpx.format.LatitudeSecond;
import io.jenetics.jpx.format.LongitudeDegree;
import io.jenetics.jpx.format.LongitudeMinute;
import io.jenetics.jpx.format.LongitudeSecond;
import io.jenetics.jpx.format.ParseException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

abstract class Field
implements Format {
    private static final DecimalFormatSymbols SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private final String _pattern;
    private final char _type;
    private boolean _prefixSign = false;
    private boolean _absolute = false;
    private final AtomicReference<NumberFormat> _format = new AtomicReference();

    Field(String pattern, char type) {
        this._pattern = Objects.requireNonNull(pattern);
        this._type = type;
        this._format.set(new DecimalFormat(Field.toDecimalPattern(pattern, type), SYMBOLS));
    }

    private static String toDecimalPattern(String pattern, char type) {
        return pattern.replace(type, '0');
    }

    final void setPrefixSign(boolean b) {
        this._prefixSign = b;
        String decimalPattern = Field.toDecimalPattern(this._pattern, this._type);
        String pattern = this._prefixSign ? "+%1$s;-%1$s".formatted(decimalPattern) : decimalPattern;
        this.setFormat(new DecimalFormat(pattern, SYMBOLS));
    }

    final boolean isPrefixSign() {
        return this._prefixSign;
    }

    final void setAbsolute(boolean b) {
        this._absolute = b;
    }

    final boolean isAbsolute() {
        return this._absolute;
    }

    final void setTruncate(boolean b) {
        this._format.get().setRoundingMode(b ? RoundingMode.DOWN : RoundingMode.HALF_EVEN);
    }

    final void setFormat(NumberFormat format) {
        this._format.set(Objects.requireNonNull(format));
    }

    final int getMinimumFractionDigits() {
        return this._format.get().getMinimumFractionDigits();
    }

    @Override
    public String toPattern() {
        return this._pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String format(double value) {
        AtomicReference<NumberFormat> atomicReference = this._format;
        synchronized (atomicReference) {
            return this._format.get().format(value);
        }
    }

    final double parse(CharSequence in, ParsePosition pos) {
        boolean strictWidth;
        int i = pos.getIndex();
        String s = in.toString();
        boolean bl = strictWidth = 1 < this._format.get().getMinimumIntegerDigits();
        if (strictWidth) {
            int end = i + this.toPattern().length();
            s = in.subSequence(0, end).toString();
        }
        Number n = this.parse0(s, pos);
        if (i == pos.getIndex()) {
            pos.setErrorIndex(i);
            throw new ParseException("Not found " + this.toPattern(), in, i);
        }
        return n.doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Number parse0(String value, ParsePosition pos) {
        AtomicReference<NumberFormat> atomicReference = this._format;
        synchronized (atomicReference) {
            return this._format.get().parse(value, pos);
        }
    }

    static double toMinutes(double degrees) {
        double dd = Math.abs(degrees);
        return (dd - Math.floor(dd)) * 60.0;
    }

    static double toSeconds(double degrees) {
        double dd = Math.abs(degrees);
        double d = Math.floor(dd);
        double m = Math.floor((dd - d) * 60.0);
        return (dd - d - m / 60.0) * 3600.0;
    }

    static Optional<Field> ofPattern(String pattern) {
        for (int i = 0; i < pattern.length(); ++i) {
            switch (pattern.charAt(i)) {
                case 'L': {
                    String p = pattern.replace('L', 'D');
                    return Optional.of(new LatitudeDegree(p));
                }
                case 'D': {
                    return Optional.of(new LatitudeDegree(pattern));
                }
                case 'M': {
                    return Optional.of(new LatitudeMinute(pattern));
                }
                case 'S': {
                    return Optional.of(new LatitudeSecond(pattern));
                }
                case 'l': {
                    String p = pattern.replace('l', 'd');
                    return Optional.of(new LongitudeDegree(p));
                }
                case 'd': {
                    return Optional.of(new LongitudeDegree(pattern));
                }
                case 'm': {
                    return Optional.of(new LongitudeMinute(pattern));
                }
                case 's': {
                    return Optional.of(new LongitudeSecond(pattern));
                }
                case 'E': {
                    return Optional.of(new Elevation(pattern));
                }
                case 'H': {
                    String p = pattern.replace('H', 'E');
                    return Optional.of(new Elevation(p));
                }
            }
        }
        return Optional.empty();
    }
}

