/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx.format;

import io.jenetics.jpx.format.Format;
import io.jenetics.jpx.format.Location;
import io.jenetics.jpx.format.LocationBuilder;
import java.text.ParsePosition;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class CompositeFormat
implements Format {
    private final List<Format> _formats;

    private CompositeFormat(List<Format> formats) {
        this._formats = List.copyOf(formats);
    }

    @Override
    public Optional<String> format(Location value) {
        List<Optional> strings = this._formats.stream().map(format -> format.format(value)).toList();
        boolean complete = strings.stream().allMatch(Optional::isPresent);
        return complete ? Optional.of(strings.stream().map(s -> (String)s.orElseThrow(AssertionError::new)).collect(Collectors.joining())) : Optional.empty();
    }

    @Override
    public void parse(CharSequence in, ParsePosition pos, LocationBuilder builder) {
        for (Format format : this._formats) {
            format.parse(in, pos, builder);
        }
    }

    @Override
    public String toPattern() {
        return this._formats.stream().map(Format::toPattern).collect(Collectors.joining());
    }

    static CompositeFormat of(List<Format> formats) {
        return new CompositeFormat(formats);
    }
}

