/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.GPX;
import io.jenetics.jpx.XMLWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

final class XMLWriters<T> {
    private final List<GPX.Version> _versions = new ArrayList<GPX.Version>();
    private final List<XMLWriter<T>> _writers = new ArrayList<XMLWriter<T>>();

    XMLWriters() {
    }

    XMLWriters<T> v00(XMLWriter<T> writer) {
        Objects.requireNonNull(writer);
        this._versions.add(null);
        this._writers.add(writer);
        return this;
    }

    XMLWriters<T> v10(XMLWriter<T> writer) {
        Objects.requireNonNull(writer);
        this._versions.add(GPX.Version.V10);
        this._writers.add(writer);
        return this;
    }

    XMLWriters<T> v11(XMLWriter<T> writer) {
        Objects.requireNonNull(writer);
        this._versions.add(GPX.Version.V11);
        this._writers.add(writer);
        return this;
    }

    XMLWriter<T>[] writers(GPX.Version version) {
        return (XMLWriter[])IntStream.range(0, this._versions.size()).filter(i -> this._versions.get(i) == null || this._versions.get(i) == version).mapToObj(this._writers::get).toArray(XMLWriter[]::new);
    }
}

