/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.DefaultXMLProvider;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;

public abstract class XMLProvider {
    private static final Object LOCK = new Object(){};
    private static volatile XMLProvider INSTANCE;

    protected XMLProvider() {
    }

    public XMLInputFactory xmlInputFactory() {
        return XMLInputFactory.newInstance();
    }

    public XMLOutputFactory xmlOutputFactory() {
        return XMLOutputFactory.newInstance();
    }

    public DocumentBuilderFactory documentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLProvider provider() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    XMLProvider.loadInstance();
                }
            }
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clear() {
        if (INSTANCE != null) {
            Object object = LOCK;
            synchronized (object) {
                if (INSTANCE != null) {
                    INSTANCE = null;
                }
            }
        }
    }

    private static void loadInstance() {
        ServiceLoader<XMLProvider> loader = ServiceLoader.load(XMLProvider.class);
        Iterator<XMLProvider> providers = loader.iterator();
        INSTANCE = providers.hasNext() ? providers.next() : new DefaultXMLProvider();
    }
}

