/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Filter;
import io.jenetics.jpx.GPX;
import io.jenetics.jpx.IO;
import io.jenetics.jpx.Length;
import io.jenetics.jpx.Lists;
import io.jenetics.jpx.NonNullList;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.WayPoint;
import io.jenetics.jpx.XML;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.w3c.dom.Document;

public final class TrackSegment
implements Iterable<WayPoint>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final List<WayPoint> _points;
    private final Document _extensions;

    private TrackSegment(List<WayPoint> points, Document extensions) {
        this._points = Lists.copyOf(points);
        this._extensions = extensions;
    }

    public List<WayPoint> getPoints() {
        return this._points;
    }

    public Stream<WayPoint> points() {
        return this._points.stream();
    }

    @Override
    public Iterator<WayPoint> iterator() {
        return this._points.iterator();
    }

    public Optional<Document> getExtensions() {
        return Optional.ofNullable(this._extensions).map(XML::clone);
    }

    public Builder toBuilder() {
        return TrackSegment.builder().points(this._points).extensions(this._extensions);
    }

    public boolean isEmpty() {
        return this._points.isEmpty();
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode(this._points);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TrackSegment && Objects.equals(((TrackSegment)obj)._points, this._points);
    }

    public String toString() {
        return String.format("TrackSegment[points=%s]", this._points.size());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TrackSegment of(List<WayPoint> points, Document extensions) {
        return new TrackSegment(points, XML.extensions(XML.clone(extensions)));
    }

    public static TrackSegment of(List<WayPoint> points) {
        return TrackSegment.of(points, null);
    }

    private Object writeReplace() {
        return new SerialProxy(16, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writes(this._points, WayPoint::write, out);
        IO.writeNullable(this._extensions, IO::write, out);
    }

    static TrackSegment read(DataInput in) throws IOException {
        return new TrackSegment(IO.reads(WayPoint::read, in), IO.readNullable(IO::readDoc, in));
    }

    static XMLWriter<TrackSegment> xmlWriter(GPX.Version version, Function<? super Number, String> formatter) {
        return XMLWriter.elem("trkseg", XMLWriter.elems(WayPoint.xmlWriter(version, "trkpt", formatter)).map(ts -> ts._points), XMLWriter.doc("extensions").map(gpx -> gpx._extensions));
    }

    static XMLReader<TrackSegment> xmlReader(GPX.Version version, Function<? super String, Length> lengthParser) {
        return XMLReader.elem(a -> new TrackSegment((List)a[0], XML.extensions((Document)a[1])), "trkseg", XMLReader.elems(WayPoint.xmlReader(version, "trkpt", lengthParser)), XMLReader.doc("extensions"));
    }

    public static final class Builder
    implements Filter<WayPoint, TrackSegment> {
        private final List<WayPoint> _points = new ArrayList<WayPoint>();
        private Document _extensions;

        private Builder() {
        }

        public Builder points(List<WayPoint> points) {
            Lists.copyTo(points, this._points);
            return this;
        }

        public Builder addPoint(WayPoint point) {
            this._points.add(Objects.requireNonNull(point));
            return this;
        }

        public Builder addPoint(Consumer<? super WayPoint.Builder> point) {
            WayPoint.Builder builder = WayPoint.builder();
            point.accept(builder);
            return this.addPoint(builder.build());
        }

        public List<WayPoint> points() {
            return new NonNullList<WayPoint>(this._points);
        }

        public Builder extensions(Document extensions) {
            this._extensions = XML.checkExtensions(extensions);
            return this;
        }

        public Optional<Document> extensions() {
            return Optional.ofNullable(this._extensions);
        }

        public Builder filter(Predicate<? super WayPoint> predicate) {
            this.points(this._points.stream().filter(predicate).toList());
            return this;
        }

        public Builder map(Function<? super WayPoint, ? extends WayPoint> mapper) {
            this.points(this._points.stream().map(mapper).map(WayPoint.class::cast).toList());
            return this;
        }

        public Builder flatMap(Function<? super WayPoint, ? extends List<WayPoint>> mapper) {
            this.points(this._points.stream().flatMap((? super T wp) -> ((List)mapper.apply((WayPoint)wp)).stream()).toList());
            return this;
        }

        public Builder listMap(Function<? super List<WayPoint>, ? extends List<WayPoint>> mapper) {
            this.points(mapper.apply(this._points));
            return this;
        }

        @Override
        public TrackSegment build() {
            return TrackSegment.of(this._points, this._extensions);
        }
    }
}

