/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Filter;
import io.jenetics.jpx.Format;
import io.jenetics.jpx.GPX;
import io.jenetics.jpx.IO;
import io.jenetics.jpx.Length;
import io.jenetics.jpx.Link;
import io.jenetics.jpx.Lists;
import io.jenetics.jpx.NonNullList;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.TrackSegment;
import io.jenetics.jpx.UInt;
import io.jenetics.jpx.XML;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLReaders;
import io.jenetics.jpx.XMLWriter;
import io.jenetics.jpx.XMLWriters;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.w3c.dom.Document;

public final class Track
implements Iterable<TrackSegment>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String _name;
    private final String _comment;
    private final String _description;
    private final String _source;
    private final List<Link> _links;
    private final UInt _number;
    private final String _type;
    private final Document _extensions;
    private final List<TrackSegment> _segments;

    private Track(String name, String comment, String description, String source, List<Link> links, UInt number, String type, Document extensions, List<TrackSegment> segments) {
        this._name = name;
        this._comment = comment;
        this._description = description;
        this._source = source;
        this._links = Lists.copyOf(links);
        this._number = number;
        this._type = type;
        this._extensions = extensions;
        this._segments = Lists.copyOf(segments);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this._name);
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this._comment);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this._description);
    }

    public Optional<String> getSource() {
        return Optional.ofNullable(this._source);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public Optional<UInt> getNumber() {
        return Optional.ofNullable(this._number);
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this._type);
    }

    public Optional<Document> getExtensions() {
        return Optional.ofNullable(this._extensions).map(XML::clone);
    }

    public List<TrackSegment> getSegments() {
        return this._segments;
    }

    public Stream<TrackSegment> segments() {
        return this._segments.stream();
    }

    @Override
    public Iterator<TrackSegment> iterator() {
        return this._segments.iterator();
    }

    public Builder toBuilder() {
        return Track.builder().name(this._name).cmt(this._comment).desc(this._description).src(this._source).links(this._links).number(this._number).extensions(this._extensions).segments(this._segments);
    }

    public boolean isEmpty() {
        return this._name == null && this._comment == null && this._description == null && this._source == null && this._links.isEmpty() && this._number == null && this._extensions == null && (this._segments.isEmpty() || this._segments.stream().allMatch(TrackSegment::isEmpty));
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this._name, this._comment, this._description, this._source, this._type, Lists.hashCode(this._links), this._number, this._segments);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Track)) return false;
        Track track = (Track)obj;
        if (!Objects.equals(track._name, this._name)) return false;
        if (!Objects.equals(track._comment, this._comment)) return false;
        if (!Objects.equals(track._description, this._description)) return false;
        if (!Objects.equals(track._source, this._source)) return false;
        if (!Objects.equals(track._type, this._type)) return false;
        if (!Lists.equals(track._links, this._links)) return false;
        if (!Objects.equals(track._number, this._number)) return false;
        if (!Objects.equals(track._segments, this._segments)) return false;
        return true;
    }

    public String toString() {
        return String.format("Track[name=%s, segments=%s]", this._name, this._segments);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Track of(String name, String comment, String description, String source, List<Link> links, UInt number, String type, Document extensions, List<TrackSegment> segments) {
        return new Track(name, comment, description, source, links, number, type, XML.extensions(XML.clone(extensions)), segments);
    }

    public static Track of(String name, String comment, String description, String source, List<Link> links, UInt number, String type, List<TrackSegment> segments) {
        return Track.of(name, comment, description, source, links, number, type, null, segments);
    }

    private Object writeReplace() {
        return new SerialProxy(15, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writeNullableString(this._name, out);
        IO.writeNullableString(this._comment, out);
        IO.writeNullableString(this._description, out);
        IO.writeNullableString(this._source, out);
        IO.writes(this._links, Link::write, out);
        IO.writeNullable(this._number, UInt::write, out);
        IO.writeNullableString(this._type, out);
        IO.writeNullable(this._extensions, IO::write, out);
        IO.writes(this._segments, TrackSegment::write, out);
    }

    static Track read(DataInput in) throws IOException {
        return new Track(IO.readNullableString(in), IO.readNullableString(in), IO.readNullableString(in), IO.readNullableString(in), IO.reads(Link::read, in), IO.readNullable(UInt::read, in), IO.readNullableString(in), IO.readNullable(IO::readDoc, in), IO.reads(TrackSegment::read, in));
    }

    private static String url(Track track) {
        return track.getLinks().isEmpty() ? null : track.getLinks().get(0).getHref().toString();
    }

    private static String urlname(Track track) {
        return track.getLinks().isEmpty() ? null : (String)track.getLinks().get(0).getText().orElse(null);
    }

    private static XMLWriters<Track> writers(Function<? super Number, String> formatter) {
        return new XMLWriters<Track>().v00(XMLWriter.elem("name").map(t -> t._name)).v00(XMLWriter.elem("cmt").map(r -> r._comment)).v00(XMLWriter.elem("desc").map(r -> r._description)).v00(XMLWriter.elem("src").map(r -> r._source)).v11(XMLWriter.elems(Link.WRITER).map(r -> r._links)).v10(XMLWriter.elem("url").map(Track::url)).v10(XMLWriter.elem("urlname").map(Track::urlname)).v00(XMLWriter.elem("number").map(r -> Format.toIntString(r._number))).v00(XMLWriter.elem("type").map(r -> r._type)).v00(XMLWriter.doc("extensions").map(gpx -> gpx._extensions)).v10(XMLWriter.elems(TrackSegment.xmlWriter(GPX.Version.V10, formatter)).map(r -> r._segments)).v11(XMLWriter.elems(TrackSegment.xmlWriter(GPX.Version.V11, formatter)).map(r -> r._segments));
    }

    private static XMLReaders readers(Function<? super String, Length> lengthParser) {
        return new XMLReaders().v00(XMLReader.elem("name")).v00(XMLReader.elem("cmt")).v00(XMLReader.elem("desc")).v00(XMLReader.elem("src")).v11(XMLReader.elems(Link.READER)).v10(XMLReader.elem("url").map(Format::parseURI)).v10(XMLReader.elem("urlname")).v00(XMLReader.elem("number").map(UInt::parse)).v00(XMLReader.elem("type")).v00(XMLReader.doc("extensions")).v10(XMLReader.elems(TrackSegment.xmlReader(GPX.Version.V10, lengthParser))).v11(XMLReader.elems(TrackSegment.xmlReader(GPX.Version.V11, lengthParser)));
    }

    static XMLWriter<Track> xmlWriter(GPX.Version version, Function<? super Number, String> formatter) {
        return XMLWriter.elem("trk", Track.writers(formatter).writers(version));
    }

    static XMLReader<Track> xmlReader(GPX.Version version, Function<? super String, Length> lengthParser) {
        return XMLReader.elem(version == GPX.Version.V10 ? Track::toTrackV10 : Track::toTrackV11, "trk", Track.readers(lengthParser).readers(version));
    }

    private static Track toTrackV11(Object[] v) {
        return new Track((String)v[0], (String)v[1], (String)v[2], (String)v[3], (List)v[4], (UInt)v[5], (String)v[6], XML.extensions((Document)v[7]), (List)v[8]);
    }

    private static Track toTrackV10(Object[] v) {
        return new Track((String)v[0], (String)v[1], (String)v[2], (String)v[3], v[4] != null ? List.of(Link.of((URI)v[4], (String)v[5], null)) : null, (UInt)v[6], (String)v[7], XML.extensions((Document)v[8]), (List)v[9]);
    }

    public static final class Builder
    implements Filter<TrackSegment, Track> {
        private String _name;
        private String _comment;
        private String _description;
        private String _source;
        private final List<Link> _links = new ArrayList<Link>();
        private UInt _number;
        private String _type;
        private Document _extensions;
        private final List<TrackSegment> _segments = new ArrayList<TrackSegment>();

        private Builder() {
        }

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Optional<String> name() {
            return Optional.ofNullable(this._name);
        }

        public Builder cmt(String comment) {
            this._comment = comment;
            return this;
        }

        public Optional<String> cmt() {
            return Optional.ofNullable(this._comment);
        }

        public Builder desc(String description) {
            this._description = description;
            return this;
        }

        public Optional<String> desc() {
            return Optional.ofNullable(this._description);
        }

        public Builder src(String source) {
            this._source = source;
            return this;
        }

        public Optional<String> src() {
            return Optional.ofNullable(this._source);
        }

        public Builder links(List<Link> links) {
            Lists.copyTo(links, this._links);
            return this;
        }

        public Builder addLink(Link link) {
            this._links.add(Objects.requireNonNull(link));
            return this;
        }

        public Builder addLink(String href) {
            return this.addLink(Link.of(href));
        }

        public List<Link> links() {
            return new NonNullList<Link>(this._links);
        }

        public Builder number(UInt number) {
            this._number = number;
            return this;
        }

        public Builder number(int number) {
            this._number = UInt.of(number);
            return this;
        }

        public Optional<UInt> number() {
            return Optional.ofNullable(this._number);
        }

        public Builder type(String type) {
            this._type = type;
            return this;
        }

        public Optional<String> type() {
            return Optional.ofNullable(this._type);
        }

        public Builder extensions(Document extensions) {
            this._extensions = XML.checkExtensions(extensions);
            return this;
        }

        public Optional<Document> extensions() {
            return Optional.ofNullable(this._extensions);
        }

        public Builder segments(List<TrackSegment> segments) {
            Lists.copyTo(segments, this._segments);
            return this;
        }

        public Builder addSegment(TrackSegment segment) {
            this._segments.add(Objects.requireNonNull(segment));
            return this;
        }

        public Builder addSegment(Consumer<? super TrackSegment.Builder> segment) {
            TrackSegment.Builder builder = TrackSegment.builder();
            segment.accept(builder);
            return this.addSegment(builder.build());
        }

        public List<TrackSegment> segments() {
            return new NonNullList<TrackSegment>(this._segments);
        }

        public Builder filter(Predicate<? super TrackSegment> predicate) {
            this.segments(this._segments.stream().filter(predicate).toList());
            return this;
        }

        public Builder map(Function<? super TrackSegment, ? extends TrackSegment> mapper) {
            this.segments(this._segments.stream().map(mapper).map(TrackSegment.class::cast).toList());
            return this;
        }

        public Builder flatMap(Function<? super TrackSegment, ? extends List<TrackSegment>> mapper) {
            this.segments(this._segments.stream().flatMap((? super T segment) -> ((List)mapper.apply((TrackSegment)segment)).stream()).toList());
            return this;
        }

        public Builder listMap(Function<? super List<TrackSegment>, ? extends List<TrackSegment>> mapper) {
            this.segments(mapper.apply(this._segments));
            return this;
        }

        @Override
        public Track build() {
            return Track.of(this._name, this._comment, this._description, this._source, this._links, this._number, this._type, this._extensions, this._segments);
        }
    }
}

