/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;

public final class Speed
extends Number
implements Comparable<Speed>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final double _value;

    private Speed(double value) {
        this._value = value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public double to(Unit unit) {
        Objects.requireNonNull(unit);
        return unit.convert(this._value, Unit.METERS_PER_SECOND);
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int compareTo(Speed speed) {
        return Double.compare(this._value, speed._value);
    }

    public int hashCode() {
        return Double.hashCode(this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Speed)) return false;
        Speed speed = (Speed)obj;
        if (Double.compare(speed._value, this._value) != 0) return false;
        return true;
    }

    public String toString() {
        return String.format("%s m/s", this._value);
    }

    public static Speed of(double speed, Unit unit) {
        Objects.requireNonNull(unit);
        return new Speed(Unit.METERS_PER_SECOND.convert(speed, unit));
    }

    static Speed parse(String value) {
        String speed = Strings.trim(value);
        return speed != null ? Speed.of(Double.parseDouble(speed), Unit.METERS_PER_SECOND) : null;
    }

    private Object writeReplace() {
        return new SerialProxy(14, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        out.writeDouble(this._value);
    }

    static Speed read(DataInput in) throws IOException {
        return new Speed(in.readDouble());
    }

    public static enum Unit {
        METERS_PER_SECOND(1.0),
        KILOMETERS_PER_HOUR(0.2777777777777778),
        MILES_PER_HOUR(0.44704),
        KNOTS(0.5144444444444445),
        MACH(331.3);

        private final double _factor;

        private Unit(double factor) {
            this._factor = factor;
        }

        public double convert(double speed, Unit sourceUnit) {
            Objects.requireNonNull(sourceUnit);
            double metersPerSecond = speed * sourceUnit._factor;
            return metersPerSecond / this._factor;
        }
    }
}

