/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Email;
import io.jenetics.jpx.IO;
import io.jenetics.jpx.Link;
import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public final class Person
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String _name;
    private final Email _email;
    private final Link _link;

    private Person(String name, Email email, Link link) {
        this._name = name;
        this._email = email;
        this._link = link;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this._name);
    }

    public Optional<Email> getEmail() {
        return Optional.ofNullable(this._email);
    }

    public Optional<Link> getLink() {
        return Optional.ofNullable(this._link);
    }

    public boolean isEmpty() {
        return this._name == null && this._email == null && this._link == null;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this._name, this._email, this._link);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Person)) return false;
        Person person = (Person)obj;
        if (!Objects.equals(person._name, this._name)) return false;
        if (!Objects.equals(person._email, this._email)) return false;
        if (!Objects.equals(person._link, this._link)) return false;
        return true;
    }

    public String toString() {
        return Objects.toString(this._name);
    }

    public static Person of(String name, Email email, Link link) {
        return new Person(name, email, link);
    }

    public static Person of(String name, Email email) {
        return new Person(name, email, null);
    }

    public static Person of(String name) {
        return new Person(name, null, null);
    }

    public static Person of() {
        return new Person(null, null, null);
    }

    private Object writeReplace() {
        return new SerialProxy(12, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        IO.writeNullableString(this._name, out);
        IO.writeNullable(this._email, Email::write, out);
        IO.writeNullable(this._link, Link::write, out);
    }

    static Person read(DataInput in) throws IOException {
        return new Person(IO.readNullableString(in), IO.readNullable(Email::read, in), IO.readNullable(Link::read, in));
    }

    static XMLWriter<Person> writer(String name) {
        return XMLWriter.elem(name, XMLWriter.elem("name").map(person -> person._name), Email.WRITER.map(person -> person._email), Link.WRITER.map(person -> person._link));
    }

    static XMLReader<Person> reader(String name) {
        return XMLReader.elem(v -> Person.of((String)v[0], (Email)v[1], (Link)v[2]), name, XMLReader.elem("name"), Email.READER, Link.READER);
    }
}

