/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

final class Lists {
    private Lists() {
    }

    static <T> List<T> copyOf(List<? extends T> list) {
        return list == null ? List.of() : List.copyOf(list);
    }

    static <T> void copyTo(List<? extends T> source, List<? super T> target) {
        Objects.requireNonNull(target);
        if (source != null) {
            source.forEach(Objects::requireNonNull);
        }
        target.clear();
        if (source != null) {
            target.addAll(source);
        }
    }

    static int hashCode(List<?> list) {
        return list != null ? 17 * list.stream().mapToInt(Objects::hashCode).sum() + 31 : 0;
    }

    static boolean equals(List<?> b, List<?> a) {
        boolean result = false;
        if (a != null) {
            if (b != null) {
                boolean bl = result = a.size() == b.size();
                if (result) {
                    result = a.isEmpty() || Lists.containsAll(a, b);
                }
            }
        } else {
            result = b == null;
        }
        return result;
    }

    private static boolean containsAll(Collection<?> a, Collection<?> b) {
        Iterator<?> ita = a.iterator();
        HashSet visited = new HashSet();
        for (Object next : b) {
            if (visited.contains(next)) continue;
            boolean foundCurrentElement = false;
            while (ita.hasNext()) {
                Object p = ita.next();
                visited.add(p);
                if (!Objects.equals(next, p)) continue;
                foundCurrentElement = true;
                break;
            }
            if (foundCurrentElement) continue;
            return false;
        }
        return true;
    }
}

