/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Objects;

public final class Length
extends Number
implements Comparable<Length>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final double _value;

    private Length(double value) {
        this._value = value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public double to(Unit unit) {
        return unit.convert(this._value, Unit.METER);
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int compareTo(Length other) {
        return Double.compare(this._value, other._value);
    }

    public int hashCode() {
        return Double.hashCode(this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Length)) return false;
        Length lng = (Length)obj;
        if (Double.compare(lng._value, this._value) != 0) return false;
        return true;
    }

    public String toString() {
        return String.format("%s m", this._value);
    }

    public static Length of(double length, Unit unit) {
        Objects.requireNonNull(unit);
        return new Length(Unit.METER.convert(length, unit));
    }

    static Length parse(String value, NumberFormat format) {
        Double length = Length.parseDouble(value, format);
        return length != null ? Length.of(length, Unit.METER) : null;
    }

    private static Double parseDouble(String value, NumberFormat format) {
        String length = Strings.trim(value);
        if (length != null) {
            try {
                return format.parse(length).doubleValue();
            }
            catch (ParseException e) {
                throw new NumberFormatException("Unable to parse " + value);
            }
        }
        return null;
    }

    private Object writeReplace() {
        return new SerialProxy(8, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        out.writeDouble(this._value);
    }

    static Length read(DataInput in) throws IOException {
        return new Length(in.readDouble());
    }

    public static enum Unit {
        METER(1.0),
        KILOMETER(1000.0),
        INCH(0.0254),
        FOOT(0.3048),
        YARD(0.9144),
        MILE(1609.344),
        FATHOM(1.853184),
        CABLE(185.3184),
        NAUTICAL_MILE(1853.184);

        private final double _factor;

        private Unit(double factor) {
            this._factor = factor;
        }

        public double convert(double length, Unit sourceUnit) {
            Objects.requireNonNull(sourceUnit);
            if (this == sourceUnit) {
                return length;
            }
            double meters = length * sourceUnit._factor;
            return meters / this._factor;
        }
    }
}

