/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class Latitude
extends Number
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final double MIN_DEGREES = -90.0;
    public static final Latitude MIN_VALUE = Latitude.ofDegrees(-90.0);
    public static final double MAX_DEGREES = 90.0;
    public static final Latitude MAX_VALUE = Latitude.ofDegrees(90.0);
    private final double _value;

    private Latitude(double value) {
        if (value < -90.0 || value > 90.0) {
            throw new IllegalArgumentException(String.format("%f is not in range [-90, 90].", value));
        }
        this._value = value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public double toRadians() {
        return Math.toRadians(this._value);
    }

    public double toDegrees() {
        return this._value;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int hashCode() {
        return Double.hashCode(this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Latitude)) return false;
        Latitude lat = (Latitude)obj;
        if (Double.compare(lat._value, this._value) != 0) return false;
        return true;
    }

    public String toString() {
        return Double.toString(this._value);
    }

    public static Latitude ofDegrees(double degrees) {
        return new Latitude(degrees);
    }

    public static Latitude ofRadians(double radians) {
        return new Latitude(Math.toDegrees(radians));
    }

    static Latitude parse(String value) {
        String lat = Strings.trim(value);
        return lat != null ? Latitude.ofDegrees(Double.parseDouble(lat)) : null;
    }

    private Object writeReplace() {
        return new SerialProxy(7, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        out.writeDouble(this._value);
    }

    static Latitude read(DataInput in) throws IOException {
        return new Latitude(in.readDouble());
    }
}

