/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Lists;
import io.jenetics.jpx.XML;
import io.jenetics.jpx.XMLProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

final class IO {
    private IO() {
    }

    static <T> void writeNullable(T value, Writer<? super T> writer, DataOutput out) throws IOException {
        out.writeBoolean(value != null);
        if (value != null) {
            writer.write(value, out);
        }
    }

    static <T> T readNullable(Reader<? extends T> reader, DataInput in) throws IOException {
        T value = null;
        if (in.readBoolean()) {
            value = reader.read(in);
        }
        return value;
    }

    static void writeString(String value, DataOutput out) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        IO.writeInt(bytes.length, out);
        out.write(bytes);
    }

    static String readString(DataInput in) throws IOException {
        byte[] bytes = new byte[IO.readInt(in)];
        in.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static void writeNullableString(String value, DataOutput out) throws IOException {
        IO.writeNullable(value, IO::writeString, out);
    }

    static String readNullableString(DataInput in) throws IOException {
        return IO.readNullable(IO::readString, in);
    }

    static <T> void writes(Collection<? extends T> elements, Writer<? super T> writer, DataOutput out) throws IOException {
        IO.writeInt(elements.size(), out);
        for (T element : elements) {
            writer.write(element, out);
        }
    }

    static <T> List<T> reads(Reader<? extends T> reader, DataInput in) throws IOException {
        int length = IO.readInt(in);
        ArrayList<T> elements = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            elements.add(reader.read(in));
        }
        return Lists.copyOf(elements);
    }

    static void writeInt(int value, DataOutput out) throws IOException {
        int n = value << 1 ^ value >> 31;
        if ((n & 0xFFFFFF80) != 0) {
            out.write((byte)((n | 0x80) & 0xFF));
            if ((n >>>= 7) > 127) {
                out.write((byte)((n | 0x80) & 0xFF));
                if ((n >>>= 7) > 127) {
                    out.write((byte)((n | 0x80) & 0xFF));
                    if ((n >>>= 7) > 127) {
                        out.write((byte)((n | 0x80) & 0xFF));
                        n >>>= 7;
                    }
                }
            }
        }
        out.write((byte)n);
    }

    static int readInt(DataInput in) throws IOException {
        int b = in.readByte() & 0xFF;
        int n = b & 0x7F;
        if (b > 127) {
            b = in.readByte() & 0xFF;
            n ^= (b & 0x7F) << 7;
            if (b > 127) {
                b = in.readByte() & 0xFF;
                n ^= (b & 0x7F) << 14;
                if (b > 127) {
                    b = in.readByte() & 0xFF;
                    n ^= (b & 0x7F) << 21;
                    if (b > 127) {
                        b = in.readByte() & 0xFF;
                        n ^= (b & 0x7F) << 28;
                        if (b > 127) {
                            throw new IOException("Invalid int encoding.");
                        }
                    }
                }
            }
        }
        return n >>> 1 ^ -(n & 1);
    }

    static void writeLong(long value, DataOutput out) throws IOException {
        long n = value << 1 ^ value >> 63;
        if ((n & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((byte)((n | 0x80L) & 0xFFL));
            if ((n >>>= 7) > 127L) {
                out.write((byte)((n | 0x80L) & 0xFFL));
                if ((n >>>= 7) > 127L) {
                    out.write((byte)((n | 0x80L) & 0xFFL));
                    if ((n >>>= 7) > 127L) {
                        out.write((byte)((n | 0x80L) & 0xFFL));
                        if ((n >>>= 7) > 127L) {
                            out.write((byte)((n | 0x80L) & 0xFFL));
                            if ((n >>>= 7) > 127L) {
                                out.write((byte)((n | 0x80L) & 0xFFL));
                                if ((n >>>= 7) > 127L) {
                                    out.write((byte)((n | 0x80L) & 0xFFL));
                                    if ((n >>>= 7) > 127L) {
                                        out.write((byte)((n | 0x80L) & 0xFFL));
                                        if ((n >>>= 7) > 127L) {
                                            out.write((byte)((n | 0x80L) & 0xFFL));
                                            n >>>= 7;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        out.write((byte)n);
    }

    static long readLong(DataInput in) throws IOException {
        long l;
        int b = in.readByte() & 0xFF;
        int n = b & 0x7F;
        if (b > 127) {
            b = in.readByte() & 0xFF;
            n ^= (b & 0x7F) << 7;
            if (b > 127) {
                b = in.readByte() & 0xFF;
                n ^= (b & 0x7F) << 14;
                if (b > 127) {
                    b = in.readByte() & 0xFF;
                    l = b > 127 ? IO.innerLongDecode(n, in) : (long)(n ^= (b & 0x7F) << 21);
                } else {
                    l = n;
                }
            } else {
                l = n;
            }
        } else {
            l = n;
        }
        return l >>> 1 ^ -(l & 1L);
    }

    private static long innerLongDecode(long l, DataInput in) throws IOException {
        int b = in.readByte() & 0xFF;
        l ^= ((long)b & 0x7FL) << 28;
        if (b > 127) {
            b = in.readByte() & 0xFF;
            l ^= ((long)b & 0x7FL) << 35;
            if (b > 127) {
                b = in.readByte() & 0xFF;
                l ^= ((long)b & 0x7FL) << 42;
                if (b > 127) {
                    b = in.readByte() & 0xFF;
                    l ^= ((long)b & 0x7FL) << 49;
                    if (b > 127) {
                        b = in.readByte() & 0xFF;
                        l ^= ((long)b & 0x7FL) << 56;
                        if (b > 127) {
                            b = in.readByte() & 0xFF;
                            l ^= ((long)b & 0x7FL) << 63;
                            if (b > 127) {
                                throw new IOException("Invalid long encoding.");
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    static void write(Document value, DataOutput out) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XML.copy((Node)value, bout);
        byte[] data = bout.toByteArray();
        IO.writeInt(data.length, out);
        out.write(data);
    }

    static Document readDoc(DataInput in) throws IOException {
        int length = IO.readInt(in);
        byte[] data = new byte[length];
        in.readFully(data);
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        try {
            return XMLProvider.provider().documentBuilderFactory().newDocumentBuilder().parse(bin);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    @FunctionalInterface
    static interface Writer<T> {
        public void write(T var1, DataOutput var2) throws IOException;
    }

    @FunctionalInterface
    static interface Reader<T> {
        public T read(DataInput var1) throws IOException;
    }
}

