/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.Strings;
import java.util.Objects;
import java.util.Optional;

public enum Fix {
    NONE("none"),
    DIM_2("2d"),
    DIM_3("3d"),
    DGPS("dgps"),
    PPS("pps");

    private final String _value;

    private Fix(String value) {
        this._value = Objects.requireNonNull(value);
    }

    public String getValue() {
        return this._value;
    }

    public static Optional<Fix> ofName(String name) {
        return switch (name) {
            case "none" -> Optional.of(NONE);
            case "2d" -> Optional.of(DIM_2);
            case "3d" -> Optional.of(DIM_3);
            case "dgps" -> Optional.of(DGPS);
            case "pps" -> Optional.of(PPS);
            default -> Optional.empty();
        };
    }

    static String format(Fix fix) {
        return fix != null ? fix._value : null;
    }

    static Fix parse(String value) {
        String fix = Strings.trim(value);
        return fix != null ? Fix.ofName(fix).orElseThrow(() -> new IllegalArgumentException(String.format("Invalid value for: '%s'.", fix))) : null;
    }
}

