/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.ReaderResult;
import io.jenetics.jpx.XMLReader;
import io.jenetics.jpx.XMLStreamReaderAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class ElemReader<T>
extends XMLReader<T> {
    private final Function<Object[], T> _creator;
    private final List<XMLReader<?>> _children;
    private final Map<String, Integer> _readerIndexMapping = new HashMap<String, Integer>();
    private final int[] _attrReaderIndexes;
    private final int[] _textReaderIndex;

    ElemReader(String name, Function<Object[], T> creator, List<XMLReader<?>> children, XMLReader.Type type) {
        super(name, type);
        this._creator = Objects.requireNonNull(creator);
        this._children = Objects.requireNonNull(children);
        for (int i2 = 0; i2 < this._children.size(); ++i2) {
            this._readerIndexMapping.put(this._children.get(i2).name(), i2);
        }
        this._attrReaderIndexes = IntStream.range(0, this._children.size()).filter(i -> this._children.get(i).type() == XMLReader.Type.ATTR).toArray();
        this._textReaderIndex = IntStream.range(0, this._children.size()).filter(i -> this._children.get(i).type() == XMLReader.Type.TEXT).toArray();
        if (this._textReaderIndex.length > 1) {
            throw new IllegalArgumentException("Found more than one TEXT reader.");
        }
    }

    @Override
    public T read(XMLStreamReaderAdapter xml, boolean lenient) throws XMLStreamException {
        while (xml.getEventType() == 5) {
            this.consumeComment(xml);
        }
        xml.require(1, null, this.name());
        List<ReaderResult> results = this._children.stream().map(ReaderResult::of).toList();
        ReaderResult text = this._textReaderIndex.length == 1 ? results.get(this._textReaderIndex[0]) : null;
        for (int attrReaderIndex : this._attrReaderIndexes) {
            ReaderResult result = results.get(attrReaderIndex);
            try {
                result.put(result.reader().read(xml, lenient));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                if (lenient) continue;
                throw e;
            }
        }
        if (xml.safeNext()) {
            boolean hasNext = false;
            block12: do {
                switch (xml.getEventType()) {
                    case 5: {
                        this.consumeComment(xml);
                        break;
                    }
                    case 1: {
                        ReaderResult result;
                        String localName = xml.getLocalName();
                        Integer index = this._readerIndexMapping.get(localName);
                        if (index == null && !lenient) {
                            throw new XMLStreamException(String.format("Unexpected element <%s>.", xml.getLocalName()));
                        }
                        ReaderResult readerResult = result = index != null ? results.get(index) : ReaderResult.of(ElemReader.elem(xml.getLocalName()));
                        if (result == null) continue block12;
                        this.throwUnexpectedElement(xml, lenient, result);
                        hasNext = xml.safeNext();
                        break;
                    }
                    case 4: 
                    case 12: {
                        if (text != null) {
                            this.throwUnexpectedElement(xml, lenient, text);
                        } else {
                            xml.next();
                        }
                        hasNext = true;
                        break;
                    }
                    case 2: 
                    case 8: {
                        try {
                            return this._creator.apply(results.stream().map(ReaderResult::value).toArray());
                        }
                        catch (IllegalArgumentException | NullPointerException e) {
                            if (!lenient) {
                                throw new XMLStreamException(String.format("Invalid value for '%s'.", this.name()), e);
                            }
                            return null;
                        }
                    }
                }
            } while (hasNext);
        }
        throw new XMLStreamException(String.format("Premature end of file while reading '%s'.", this.name()));
    }

    private void consumeComment(XMLStreamReader xml) throws XMLStreamException {
        assert (xml.getEventType() == 5);
        if (xml.hasNext()) {
            xml.next();
        }
    }

    private void throwUnexpectedElement(XMLStreamReaderAdapter xml, boolean lenient, ReaderResult text) throws XMLStreamException {
        block2: {
            try {
                text.put(text.reader().read(xml, lenient));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                if (lenient) break block2;
                XMLStreamException exp = new XMLStreamException(String.format("Unexpected element <%s>.", xml.getLocalName()));
                exp.addSuppressed(e);
                throw exp;
            }
        }
    }
}

