/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.jpx;

import io.jenetics.jpx.SerialProxy;
import io.jenetics.jpx.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class Degrees
extends Number
implements Comparable<Degrees>,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final double MIN_VALUE = 0.0;
    public static final double MAX_VALUE = 360.0;
    private final double _value;

    private Degrees(double value) {
        if (value < 0.0 || value >= 360.0) {
            throw new IllegalArgumentException(String.format("%f not in the range [0, 360).", value));
        }
        this._value = value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public double toRadians() {
        return Math.toRadians(this._value);
    }

    public double toDegrees() {
        return this._value;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int compareTo(Degrees other) {
        return Double.compare(this._value, other._value);
    }

    public int hashCode() {
        return Double.hashCode(this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Degrees)) return false;
        Degrees deg = (Degrees)obj;
        if (Double.compare(deg._value, this._value) != 0) return false;
        return true;
    }

    public String toString() {
        return Double.toString(this._value);
    }

    public static Degrees ofDegrees(double degrees) {
        return new Degrees(degrees);
    }

    public static Degrees ofRadians(double radians) {
        return new Degrees(Math.toDegrees(radians));
    }

    static Degrees parse(String value) {
        String deg = Strings.trim(value);
        return deg != null ? Degrees.ofDegrees(Double.parseDouble(deg)) : null;
    }

    private Object writeReplace() {
        return new SerialProxy(3, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    void write(DataOutput out) throws IOException {
        out.writeDouble(this._value);
    }

    static Degrees read(DataInput in) throws IOException {
        return new Degrees(in.readDouble());
    }
}

