/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.openapi.plugin.swagger;

import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.openapi.plugin.swagger.SwaggerHandler;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u008b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f0\u000e\u0012\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f0\u000e\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0003*\u00020\u0003H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/javalin/openapi/plugin/swagger/SwaggerHandler;", "Lio/javalin/http/Handler;", "title", "", "documentationPath", "versions", "", "swaggerVersion", "validatorUrl", "routingPath", "basePath", "tagsSorter", "operationsSorter", "customStylesheetFiles", "", "Lkotlin/Pair;", "customJavaScriptFiles", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "swaggerUiHtml", "createSwaggerUiHtml", "handle", "", "context", "Lio/javalin/http/Context;", "removedDoubledPathOperators", "javalin-swagger-plugin"})
public final class SwaggerHandler
implements Handler {
    @NotNull
    private final String title;
    @NotNull
    private final String documentationPath;
    @NotNull
    private final Set<String> versions;
    @NotNull
    private final String swaggerVersion;
    @Nullable
    private final String validatorUrl;
    @NotNull
    private final String routingPath;
    @Nullable
    private final String basePath;
    @NotNull
    private final String tagsSorter;
    @NotNull
    private final String operationsSorter;
    @NotNull
    private final List<Pair<String, String>> customStylesheetFiles;
    @NotNull
    private final List<Pair<String, String>> customJavaScriptFiles;
    @NotNull
    private final String swaggerUiHtml;

    public SwaggerHandler(@NotNull String title, @NotNull String documentationPath, @NotNull Set<String> versions, @NotNull String swaggerVersion, @Nullable String validatorUrl, @NotNull String routingPath, @Nullable String basePath, @NotNull String tagsSorter, @NotNull String operationsSorter, @NotNull List<Pair<String, String>> customStylesheetFiles, @NotNull List<Pair<String, String>> customJavaScriptFiles) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)documentationPath, (String)"documentationPath");
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Intrinsics.checkNotNullParameter((Object)swaggerVersion, (String)"swaggerVersion");
        Intrinsics.checkNotNullParameter((Object)routingPath, (String)"routingPath");
        Intrinsics.checkNotNullParameter((Object)tagsSorter, (String)"tagsSorter");
        Intrinsics.checkNotNullParameter((Object)operationsSorter, (String)"operationsSorter");
        Intrinsics.checkNotNullParameter(customStylesheetFiles, (String)"customStylesheetFiles");
        Intrinsics.checkNotNullParameter(customJavaScriptFiles, (String)"customJavaScriptFiles");
        this.title = title;
        this.documentationPath = documentationPath;
        this.versions = versions;
        this.swaggerVersion = swaggerVersion;
        this.validatorUrl = validatorUrl;
        this.routingPath = routingPath;
        this.basePath = basePath;
        this.tagsSorter = tagsSorter;
        this.operationsSorter = operationsSorter;
        this.customStylesheetFiles = customStylesheetFiles;
        this.customJavaScriptFiles = customJavaScriptFiles;
        this.swaggerUiHtml = this.createSwaggerUiHtml();
    }

    public void handle(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.html(this.swaggerUiHtml).res().setCharacterEncoding("UTF-8");
    }

    private final String createSwaggerUiHtml() {
        String string = this.basePath;
        if (string == null) {
            string = "";
        }
        String rootPath = string + this.routingPath;
        String publicSwaggerAssetsPath = this.removedDoubledPathOperators(rootPath + "/webjars/swagger-ui/" + this.swaggerVersion);
        String publicDocumentationPath = this.removedDoubledPathOperators(rootPath + this.documentationPath);
        String allDocumentations2 = CollectionsKt.joinToString$default((Iterable)this.versions, (CharSequence)",\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(publicDocumentationPath){
            final /* synthetic */ String $publicDocumentationPath;
            {
                this.$publicDocumentationPath = $publicDocumentationPath;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "{ name: '" + it + "', url: '" + this.$publicDocumentationPath + "?v=" + it + "' }";
            }
        }), (int)30, null);
        String allCustomStylesheets2 = CollectionsKt.joinToString$default((Iterable)this.customStylesheetFiles, (CharSequence)"\n", null, null, (int)0, null, (Function1)createSwaggerUiHtml.allCustomStylesheets.1.INSTANCE, (int)30, null);
        String allCustomJavaScripts2 = CollectionsKt.joinToString$default((Iterable)this.customJavaScriptFiles, (CharSequence)"\n", null, null, (int)0, null, (Function1)createSwaggerUiHtml.allCustomJavaScripts.1.INSTANCE, (int)30, null);
        String html = StringsKt.trimIndent((String)("\n        <!-- HTML for static distribution bundle build -->\n        <!DOCTYPE html>\n        <html lang=\"en\">\n            <head>\n                <meta charset=\"UTF-8\">\n                <title>" + this.title + "</title>\n                <link rel=\"stylesheet\" type=\"text/css\" href=\"" + publicSwaggerAssetsPath + "/swagger-ui.css\" >\n                <link rel=\"icon\" type=\"image/png\" href=\"" + publicSwaggerAssetsPath + "/favicon-32x32.png\" sizes=\"32x32\" />\n                " + allCustomStylesheets2 + "\n                <style>\n                    html {\n                        box-sizing: border-box;\n                        overflow: -moz-scrollbars-vertical;\n                        overflow-y: scroll;\n                    }\n                    *, *:before, *:after {\n                        box-sizing: inherit;\n                    }\n                    body {\n                        margin:0;\n                        background: #fafafa;\n                    }\n                </style>\n            </head>\n            <body>\n                <div id=\"swagger-ui\"></div>\n                <script src=\"" + publicSwaggerAssetsPath + "/swagger-ui-bundle.js\"> </script>\n                <script src=\"" + publicSwaggerAssetsPath + "/swagger-ui-standalone-preset.js\"> </script>\n                <script>\n                window.onload = function() {\n                    window.ui = SwaggerUIBundle({\n                        urls: [\n                            " + allDocumentations2 + "\n                        ],\n                        dom_id: \"#swagger-ui\",\n                        deepLinking: true,\n                        presets: [\n                          SwaggerUIBundle.presets.apis,\n                          SwaggerUIStandalonePreset\n                        ],\n                        plugins: [\n                          SwaggerUIBundle.plugins.DownloadUrl\n                        ],\n                        layout: \"StandaloneLayout\",\n                        tagsSorter: " + this.tagsSorter + ",\n                        operationsSorter: " + this.operationsSorter + ",\n                        validatorUrl: " + (String)(this.validatorUrl != null ? "\"" + this.validatorUrl + "\"" : "null") + "\n                      })\n                }\n                </script>\n                " + allCustomJavaScripts2 + "\n            </body>\n        </html>\n    "));
        return html;
    }

    private final String removedDoubledPathOperators(String $this$removedDoubledPathOperators) {
        Regex multiplePathOperatorsRegex = new Regex("/+");
        CharSequence charSequence = $this$removedDoubledPathOperators;
        String string = "/";
        return multiplePathOperatorsRegex.replace(charSequence, string);
    }
}

