/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.zipkin.internal;

import com.google.gson.Gson;
import com.twitter.zipkin.thriftjava.Annotation;
import com.twitter.zipkin.thriftjava.AnnotationType;
import com.twitter.zipkin.thriftjava.BinaryAnnotation;
import com.twitter.zipkin.thriftjava.Endpoint;
import com.twitter.zipkin.thriftjava.Span;
import io.jaegertracing.internal.JaegerSpan;
import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.LogData;
import io.jaegertracing.zipkin.internal.ConverterUtil;
import io.opentracing.tag.Tags;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThriftSpanConverter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Gson gson = new Gson();

    public static Span convertSpan(JaegerSpan jaegerSpan) {
        JaegerTracer tracer = jaegerSpan.getTracer();
        Endpoint host = new Endpoint(tracer.getIpv4(), 0, tracer.getServiceName());
        JaegerSpanContext context = jaegerSpan.context();
        return new Span(context.getTraceIdLow(), jaegerSpan.getOperationName(), context.getSpanId(), ThriftSpanConverter.buildAnnotations(jaegerSpan, host), ThriftSpanConverter.buildBinaryAnnotations(jaegerSpan, host)).setParent_id(context.getParentId()).setTrace_id_high(context.getTraceIdHigh()).setDebug(context.isDebug()).setTimestamp(jaegerSpan.getStart()).setDuration(jaegerSpan.getDuration());
    }

    private static List<Annotation> buildAnnotations(JaegerSpan jaegerSpan, Endpoint host) {
        List logs;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (ConverterUtil.isRpc(jaegerSpan)) {
            String startLabel = "sr";
            String endLabel = "ss";
            if (ConverterUtil.isRpcClient(jaegerSpan)) {
                startLabel = "cs";
                endLabel = "cr";
            }
            annotations.add(new Annotation(jaegerSpan.getStart(), startLabel).setHost(host));
            annotations.add(new Annotation(jaegerSpan.getStart() + jaegerSpan.getDuration(), endLabel).setHost(host));
        }
        if ((logs = jaegerSpan.getLogs()) != null) {
            for (LogData logData : logs) {
                String logMessage = logData.getMessage();
                Map logFields = logData.getFields();
                if (logMessage != null) {
                    annotations.add(new Annotation(logData.getTime(), logMessage));
                    continue;
                }
                if (logFields == null) continue;
                annotations.add(new Annotation(logData.getTime(), gson.toJson((Object)logFields)));
            }
        }
        return annotations;
    }

    private static List<BinaryAnnotation> buildBinaryAnnotations(JaegerSpan jaegerSpan, Endpoint host) {
        Endpoint peerEndpoint;
        Object tagValue;
        String tagKey;
        boolean firstSpanInProcess;
        ArrayList<BinaryAnnotation> binaryAnnotations = new ArrayList<BinaryAnnotation>();
        Map tags = jaegerSpan.getTags();
        boolean isRpc = ConverterUtil.isRpc(jaegerSpan);
        boolean isClient = ConverterUtil.isRpcClient(jaegerSpan);
        boolean bl = firstSpanInProcess = jaegerSpan.getReferences().isEmpty() || ConverterUtil.isRpcServer(jaegerSpan);
        if (firstSpanInProcess) {
            Map processTags = jaegerSpan.getTracer().tags();
            for (Map.Entry entry : processTags.entrySet()) {
                tagKey = (String)entry.getKey();
                if ("ip".equals(tagKey)) continue;
                tagValue = entry.getValue();
                binaryAnnotations.add(ThriftSpanConverter.buildBinaryAnnotation("tracer." + tagKey, tagValue));
            }
        }
        if ((peerEndpoint = ThriftSpanConverter.extractPeerEndpoint(tags)) != null && isClient) {
            String key = isClient ? "sa" : "ca";
            binaryAnnotations.add(new BinaryAnnotation().setKey(key).setValue(new byte[]{1}).setAnnotation_type(AnnotationType.BOOL).setHost(peerEndpoint));
        }
        if (!isRpc) {
            Object componentTag = tags.get(Tags.COMPONENT.getKey());
            byte[] componentName = componentTag instanceof String ? componentTag.toString().getBytes(UTF_8) : jaegerSpan.getTracer().getServiceName().getBytes(UTF_8);
            binaryAnnotations.add(new BinaryAnnotation().setKey("lc").setValue(componentName).setAnnotation_type(AnnotationType.STRING).setHost(host));
        }
        if (tags != null) {
            for (Map.Entry entry : tags.entrySet()) {
                tagKey = (String)entry.getKey();
                tagValue = entry.getValue();
                binaryAnnotations.add(ThriftSpanConverter.buildBinaryAnnotation(tagKey, tagValue));
            }
        }
        return binaryAnnotations;
    }

    private static BinaryAnnotation buildBinaryAnnotation(String tagKey, Object tagValue) {
        BinaryAnnotation banno = new BinaryAnnotation().setKey(tagKey);
        banno.setValue(String.valueOf(tagValue).getBytes(UTF_8)).setAnnotation_type(AnnotationType.STRING);
        return banno;
    }

    public static Endpoint extractPeerEndpoint(Map<String, Object> tags) {
        Object peerIpv4 = tags.get(Tags.PEER_HOST_IPV4.getKey());
        Object peerPort = tags.get(Tags.PEER_PORT.getKey());
        Object peerService = tags.get(Tags.PEER_SERVICE.getKey());
        if (peerIpv4 == null && peerPort == null && peerService == null) {
            return null;
        }
        Endpoint peerEndpoint = new Endpoint(0, 0, "");
        if (peerIpv4 instanceof Integer) {
            peerEndpoint.setIpv4(((Integer)peerIpv4).intValue());
        }
        if (peerPort instanceof Number) {
            peerEndpoint.setPort(((Number)peerPort).shortValue());
        }
        if (peerService instanceof String) {
            peerEndpoint.setService_name((String)peerService);
        }
        return peerEndpoint;
    }
}

