/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.zipkin;

import com.twitter.zipkin.thriftjava.Annotation;
import com.twitter.zipkin.thriftjava.BinaryAnnotation;
import com.twitter.zipkin.thriftjava.Endpoint;
import com.twitter.zipkin.thriftjava.Span;
import io.jaegertracing.internal.JaegerSpan;
import io.jaegertracing.internal.exceptions.SenderException;
import io.jaegertracing.zipkin.internal.ThriftSpanConverter;
import io.jaegertracing.zipkin.internal.ThriftSpanEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import zipkin2.codec.Encoding;
import zipkin2.reporter.Sender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

public final class ZipkinSender
implements io.jaegertracing.spi.Sender {
    static final Set<String> CORE_ANNOTATIONS = new LinkedHashSet<String>(Arrays.asList("cs", "cr", "ss", "sr"));
    final Sender delegate;
    final ThriftSpanEncoder encoder = new ThriftSpanEncoder();
    final List<byte[]> spanBuffer;

    public static ZipkinSender create(String endpoint) {
        return new ZipkinSender((Sender)URLConnectionSender.newBuilder().encoding(Encoding.THRIFT).endpoint(endpoint).build());
    }

    public static ZipkinSender create(Sender delegate) {
        if (delegate.encoding() != Encoding.THRIFT) {
            throw new IllegalArgumentException("Sender.encoding != THRIFT");
        }
        return new ZipkinSender(delegate);
    }

    ZipkinSender(Sender delegate) {
        this.delegate = delegate;
        this.spanBuffer = new ArrayList<byte[]>();
    }

    public int append(JaegerSpan span) throws SenderException {
        int n;
        byte[] next = this.encoder.encode(ZipkinSender.backFillHostOnAnnotations(ThriftSpanConverter.convertSpan(span)));
        int messageSizeOfNextSpan = this.delegate.messageSizeInBytes(Collections.singletonList(next));
        if (messageSizeOfNextSpan > this.delegate.messageMaxBytes()) {
            throw new SenderException(this.delegate.toString() + " received a span that was too large", null, 1);
        }
        this.spanBuffer.add(next);
        int nextSizeInBytes = this.delegate.messageSizeInBytes(this.spanBuffer);
        if (nextSizeInBytes <= this.delegate.messageMaxBytes()) {
            if (nextSizeInBytes < this.delegate.messageMaxBytes()) {
                return 0;
            }
            return this.flush();
        }
        this.spanBuffer.remove(this.spanBuffer.size() - 1);
        try {
            n = this.flush();
        }
        catch (SenderException e) {
            throw new SenderException(e.getMessage(), e.getCause(), e.getDroppedSpanCount() + 1);
        }
        this.spanBuffer.add(next);
        return n;
    }

    public int flush() throws SenderException {
        if (this.spanBuffer.isEmpty()) {
            return 0;
        }
        int n = this.spanBuffer.size();
        try {
            this.delegate.sendSpans(this.spanBuffer).execute();
        }
        catch (RuntimeException e) {
            throw new SenderException("Failed to flush spans.", (Throwable)e, n);
        }
        catch (IOException e) {
            throw new SenderException("Failed to flush spans.", (Throwable)e, n);
        }
        finally {
            this.spanBuffer.clear();
        }
        return n;
    }

    public int close() throws SenderException {
        int n = this.flush();
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new SenderException("Failed to close " + this.delegate, (Throwable)e, n);
        }
        return n;
    }

    static Span backFillHostOnAnnotations(Span span) {
        Endpoint host = ZipkinSender.getServiceEndpoint(span);
        if (host != null) {
            for (BinaryAnnotation binaryAnnotation : span.getBinary_annotations()) {
                if (binaryAnnotation.isSetHost()) continue;
                binaryAnnotation.setHost(host);
            }
            for (Annotation annotation : span.getAnnotations()) {
                if (annotation.isSetHost()) continue;
                annotation.setHost(host);
            }
        }
        return span;
    }

    static Endpoint getServiceEndpoint(Span span) {
        for (Annotation annotation : span.getAnnotations()) {
            if (!CORE_ANNOTATIONS.contains(annotation.getValue()) || !annotation.isSetHost()) continue;
            return annotation.getHost();
        }
        for (BinaryAnnotation binaryAnnotation : span.getBinary_annotations()) {
            if (!"lc".equals(binaryAnnotation.getKey())) continue;
            return binaryAnnotation.getHost();
        }
        return null;
    }

    public String toString() {
        return "ZipkinSender(delegate=" + this.delegate + ")";
    }
}

