/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.zipkin.internal;

import com.google.gson.Gson;
import io.jaegertracing.internal.JaegerSpan;
import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.LogData;
import io.jaegertracing.zipkin.internal.ConverterUtil;
import io.opentracing.tag.Tags;
import java.util.List;
import java.util.Map;
import zipkin2.Endpoint;
import zipkin2.Span;

public class V2SpanConverter {
    private static final Gson gson = new Gson();

    public static Span convertSpan(JaegerSpan span) {
        JaegerTracer tracer = span.getTracer();
        Endpoint.Builder host = Endpoint.newBuilder().serviceName(tracer.getServiceName());
        if (tracer.getIpv4() != 0) {
            host.parseIp(V2SpanConverter.convertIp(tracer.getIpv4()));
        }
        Endpoint peerEndpoint = V2SpanConverter.extractPeerEndpoint(span.getTags());
        JaegerSpanContext context = span.context();
        Span.Builder builder = Span.newBuilder().id(Long.toHexString(context.getSpanId())).traceId(context.getTraceIdHigh(), context.getTraceIdLow()).name(span.getOperationName()).parentId(Long.toHexString(context.getParentId())).debug(context.isDebug()).localEndpoint(host.build()).remoteEndpoint(peerEndpoint).kind(V2SpanConverter.convertKind(span.getTags().get(Tags.SPAN_KIND.getKey()))).timestamp(span.getStart()).duration(span.getDuration());
        V2SpanConverter.buildAnnotations(span, builder);
        V2SpanConverter.buildTags(span, builder);
        return builder.build();
    }

    private static Span.Kind convertKind(Object kind) {
        if ("server".equals(kind)) {
            return Span.Kind.SERVER;
        }
        if ("client".equals(kind)) {
            return Span.Kind.CLIENT;
        }
        if ("consumer".equals(kind)) {
            return Span.Kind.CONSUMER;
        }
        if ("producer".equals(kind)) {
            return Span.Kind.PRODUCER;
        }
        return null;
    }

    private static void buildAnnotations(JaegerSpan jaegerSpan, Span.Builder builder) {
        List logs = jaegerSpan.getLogs();
        if (logs != null) {
            for (LogData logData : logs) {
                String logMessage = logData.getMessage();
                Map logFields = logData.getFields();
                if (logMessage != null) {
                    builder.addAnnotation(logData.getTime(), logMessage);
                    continue;
                }
                if (logFields == null) continue;
                builder.addAnnotation(logData.getTime(), gson.toJson((Object)logFields));
            }
        }
    }

    private static void buildTags(JaegerSpan jaegerSpan, Span.Builder builder) {
        boolean firstSpanInProcess;
        Map tags = jaegerSpan.getTags();
        boolean bl = firstSpanInProcess = jaegerSpan.getReferences().isEmpty() || ConverterUtil.isRpcServer(jaegerSpan);
        if (firstSpanInProcess) {
            Map processTags = jaegerSpan.getTracer().tags();
            for (Map.Entry entry : processTags.entrySet()) {
                String tagKey = (String)entry.getKey();
                if ("ip".equals(tagKey)) continue;
                Object tagValue = entry.getValue();
                builder.putTag("tracer." + tagKey, tagValue.toString());
            }
        }
        if (tags != null) {
            for (Map.Entry entry : tags.entrySet()) {
                String tagKey = (String)entry.getKey();
                Object tagValue = entry.getValue();
                builder.putTag(tagKey, tagValue.toString());
            }
        }
    }

    private static byte[] convertIp(int ipv4) {
        return new byte[]{(byte)(ipv4 >> 24 & 0xFF), (byte)(ipv4 >> 16 & 0xFF), (byte)(ipv4 >> 8 & 0xFF), (byte)(ipv4 & 0xFF)};
    }

    public static Endpoint extractPeerEndpoint(Map<String, Object> tags) {
        Object peerIpv4 = tags.get(Tags.PEER_HOST_IPV4.getKey());
        Object peerPort = tags.get(Tags.PEER_PORT.getKey());
        Object peerService = tags.get(Tags.PEER_SERVICE.getKey());
        if (peerIpv4 == null && peerPort == null && peerService == null) {
            return null;
        }
        Endpoint.Builder builder = Endpoint.newBuilder();
        if (peerIpv4 instanceof String) {
            builder.ip((String)peerIpv4);
        }
        if (peerPort instanceof Number) {
            builder.port(((Number)peerPort).intValue());
        }
        if (peerService instanceof String) {
            builder.serviceName((String)peerService);
        }
        return builder.build();
    }
}

