/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.crossdock.resources.behavior.tchannel;

import com.uber.tchannel.api.TChannel;
import com.uber.tchannel.api.handlers.RequestHandler;
import com.uber.tchannel.tracing.TracingContext;
import io.jaegertracing.crossdock.resources.behavior.TraceBehavior;
import io.jaegertracing.crossdock.resources.behavior.tchannel.JoinTraceThriftHandler;
import io.netty.channel.ChannelFuture;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.EmptyStackException;

public class TChannelServer {
    public static TChannel server;

    public TChannelServer(TChannel.Builder tchannelBuilder, TraceBehavior behavior, Tracer tracer) {
        server = tchannelBuilder.setTracer(tracer).setTracingContext((TracingContext)new TracingContextAdapter(tracer)).build();
        server.makeSubChannel(server.getServiceName()).registerHealthHandler().register("TracedService::joinTrace", (RequestHandler)new JoinTraceThriftHandler(behavior));
    }

    public TChannel getChannel() {
        return server;
    }

    public void start() throws InterruptedException {
        ChannelFuture serverFuture = server.listen().awaitUninterruptibly();
        if (!serverFuture.isSuccess()) {
            throw new RuntimeException("Server future unsuccessful");
        }
    }

    public void shutdown() {
        server.shutdown(true);
    }

    private static class TracingContextAdapter
    implements TracingContext {
        private final Tracer tracer;

        public TracingContextAdapter(Tracer tracer) {
            this.tracer = tracer;
        }

        public void pushSpan(Span span) {
            this.tracer.scopeManager().activate(span, false);
        }

        public boolean hasSpan() {
            return this.tracer.activeSpan() != null;
        }

        public Span currentSpan() throws EmptyStackException {
            return this.tracer.activeSpan();
        }

        public Span popSpan() throws EmptyStackException {
            Scope scope = this.tracer.scopeManager().active();
            if (scope != null) {
                scope.close();
                return scope.span();
            }
            return null;
        }

        public void clear() {
        }
    }
}

