/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.crossdock.resources.behavior.tchannel;

import com.uber.tchannel.api.handlers.ThriftRequestHandler;
import com.uber.tchannel.messages.ThriftRequest;
import com.uber.tchannel.messages.ThriftResponse;
import io.jaegertracing.crossdock.api.Downstream;
import io.jaegertracing.crossdock.api.TraceResponse;
import io.jaegertracing.crossdock.resources.behavior.TraceBehavior;
import io.jaegertracing.crossdock.thrift.JoinTraceRequest;
import io.jaegertracing.crossdock.thrift.TracedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JoinTraceThriftHandler
extends ThriftRequestHandler<TracedService.joinTrace_args, TracedService.joinTrace_result> {
    private static final Logger log = LoggerFactory.getLogger(JoinTraceThriftHandler.class);
    private final TraceBehavior behavior;

    JoinTraceThriftHandler(TraceBehavior behavior) {
        this.behavior = behavior;
    }

    public ThriftResponse<TracedService.joinTrace_result> handleImpl(ThriftRequest<TracedService.joinTrace_args> thriftRequest) {
        TraceResponse response;
        JoinTraceRequest request = ((TracedService.joinTrace_args)thriftRequest.getBody(TracedService.joinTrace_args.class)).getRequest();
        log.info("thrift:join_trace request: {}", (Object)request);
        try {
            response = this.behavior.prepareResponse(Downstream.fromThrift(request.getDownstream()));
        }
        catch (Exception e) {
            log.error("Failed to call downstream", (Throwable)e);
            response = new TraceResponse(e.getMessage());
        }
        log.info("thrift:join_trace response: {}", (Object)response);
        return new ThriftResponse.Builder(thriftRequest).setBody((Object)new TracedService.joinTrace_result(TraceResponse.toThrift(response))).build();
    }
}

