/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.crossdock.resources.behavior.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jaegertracing.Span;
import io.jaegertracing.crossdock.api.JoinTraceRequest;
import io.jaegertracing.crossdock.api.StartTraceRequest;
import io.jaegertracing.crossdock.api.TraceResponse;
import io.jaegertracing.crossdock.resources.behavior.TraceBehavior;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
@Provider
public class TraceBehaviorResource {
    private static final Logger log = LoggerFactory.getLogger(TraceBehaviorResource.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final TraceBehavior behavior;
    private final Tracer tracer;

    public TraceBehaviorResource(Tracer tracer) {
        this.tracer = tracer;
        this.behavior = new TraceBehavior(tracer);
    }

    @POST
    @Path(value="start_trace")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TraceResponse startTrace(StartTraceRequest startRequest) throws Exception {
        log.info("http:start_trace request: {}", (Object)this.mapper.writeValueAsString((Object)startRequest));
        String baggage = startRequest.getBaggage();
        Span span = (Span)this.tracer.activeSpan();
        span.setBaggageItem("crossdock-baggage-key", baggage);
        if (startRequest.isSampled()) {
            Tags.SAMPLING_PRIORITY.set((io.opentracing.Span)span, Integer.valueOf(1));
        }
        TraceResponse response = this.behavior.prepareResponse(startRequest.getDownstream());
        log.info("http:start_trace response: {}", (Object)this.mapper.writeValueAsString((Object)response));
        return response;
    }

    @POST
    @Path(value="join_trace")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TraceResponse joinTrace(JoinTraceRequest joinRequest) throws Exception {
        log.info("http:join_trace request: {}", (Object)this.mapper.writeValueAsString((Object)joinRequest));
        TraceResponse response = this.behavior.prepareResponse(joinRequest.getDownstream());
        log.info("http:join_trace response: {}", (Object)this.mapper.writeValueAsString((Object)response));
        return response;
    }
}

