/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.crossdock.resources.behavior;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.uber.tchannel.api.SubChannel;
import com.uber.tchannel.api.TFuture;
import com.uber.tchannel.messages.ThriftRequest;
import com.uber.tchannel.messages.ThriftResponse;
import io.jaegertracing.Span;
import io.jaegertracing.SpanContext;
import io.jaegertracing.crossdock.JerseyServer;
import io.jaegertracing.crossdock.api.Downstream;
import io.jaegertracing.crossdock.api.JoinTraceRequest;
import io.jaegertracing.crossdock.api.ObservedSpan;
import io.jaegertracing.crossdock.api.TraceResponse;
import io.jaegertracing.crossdock.resources.behavior.tchannel.TChannelServer;
import io.jaegertracing.crossdock.thrift.TracedService;
import io.opentracing.Tracer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceBehavior {
    private static final Logger log = LoggerFactory.getLogger(TraceBehavior.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Tracer tracer;

    public TraceBehavior(Tracer tracer) {
        this.tracer = tracer;
    }

    public TraceResponse prepareResponse(Downstream downstream) throws Exception {
        TraceResponse response = new TraceResponse(this.observeSpan());
        if (downstream != null) {
            TraceResponse downstreamResponse = this.callDownstream(downstream);
            response.setDownstream(downstreamResponse);
        }
        return response;
    }

    private TraceResponse callDownstream(Downstream downstream) throws Exception {
        String transport;
        log.info("Calling downstream {}", (Object)downstream);
        log.info("Downstream service {} -> {}:{}", new Object[]{downstream.getServiceName(), InetAddress.getByName(downstream.getHost()), downstream.getPort()});
        switch (transport = downstream.getTransport()) {
            case "HTTP": {
                return this.callDownstreamHttp(downstream);
            }
            case "TCHANNEL": {
                return this.callDownstreamTChannel(downstream);
            }
        }
        return new TraceResponse("Unrecognized transport received: %s" + transport);
    }

    private TraceResponse callDownstreamHttp(Downstream downstream) throws IOException {
        String downstreamUrl = String.format("http://%s:%s/join_trace", downstream.getHost(), downstream.getPort());
        log.info("Calling downstream http {} at {}", (Object)downstream.getServiceName(), (Object)downstreamUrl);
        Response resp = JerseyServer.client.target(downstreamUrl).request(new String[]{"application/json"}).post(Entity.json((Object)new JoinTraceRequest(downstream.getServerRole(), downstream.getDownstream())));
        String respStr = (String)resp.readEntity(String.class);
        TraceResponse response = (TraceResponse)mapper.readValue(respStr, TraceResponse.class);
        log.info("Received response {}", (Object)response);
        return response;
    }

    public TraceResponse callDownstreamTChannel(Downstream downstream) throws Exception {
        io.jaegertracing.crossdock.thrift.JoinTraceRequest joinTraceRequest = new io.jaegertracing.crossdock.thrift.JoinTraceRequest(downstream.getServerRole());
        joinTraceRequest.setDownstream(Downstream.toThrift(downstream.getDownstream()));
        SubChannel subChannel = TChannelServer.server.makeSubChannel(downstream.getServiceName());
        log.info("Calling downstream tchannel {}", (Object)joinTraceRequest);
        ThriftRequest thriftRequest = new ThriftRequest.Builder(downstream.getServiceName(), "TracedService::joinTrace").setTimeout(2000L).setBody((Object)new TracedService.joinTrace_args(joinTraceRequest)).build();
        TFuture future = subChannel.send(thriftRequest, this.host(downstream), this.port(downstream));
        try (ThriftResponse thriftResponse = (ThriftResponse)future.get();){
            log.info("Received tchannel response {}", (Object)thriftResponse);
            if (thriftResponse.isError()) {
                throw new Exception(thriftResponse.getError().getMessage());
            }
            TraceResponse traceResponse = TraceResponse.fromThrift(((TracedService.joinTrace_result)thriftResponse.getBody(TracedService.joinTrace_result.class)).getSuccess());
            return traceResponse;
        }
    }

    private ObservedSpan observeSpan() {
        Span span = (Span)this.tracer.activeSpan();
        if (this.tracer.activeSpan() == null) {
            log.error("No span found");
            return new ObservedSpan("no span found", false, "no span found");
        }
        SpanContext context = span.context();
        String traceId = String.format("%x", context.getTraceId());
        boolean sampled = context.isSampled();
        String baggage = span.getBaggageItem("crossdock-baggage-key");
        return new ObservedSpan(traceId, sampled, baggage);
    }

    private InetAddress host(Downstream downstream) {
        try {
            return InetAddress.getByName(downstream.getHost());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Cannot resolve host address for " + downstream.getHost(), e);
        }
    }

    private int port(Downstream downstream) {
        return Integer.parseInt(downstream.getPort());
    }
}

