/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.crossdock.resources.behavior;

import io.jaegertracing.Tracer;
import io.jaegertracing.crossdock.api.CreateTracesRequest;
import io.jaegertracing.metrics.Metrics;
import io.jaegertracing.metrics.MetricsFactory;
import io.jaegertracing.metrics.NoopMetricsFactory;
import io.jaegertracing.reporters.RemoteReporter;
import io.jaegertracing.reporters.Reporter;
import io.jaegertracing.samplers.ConstSampler;
import io.jaegertracing.samplers.HttpSamplingManager;
import io.jaegertracing.samplers.ProbabilisticSampler;
import io.jaegertracing.samplers.RemoteControlledSampler;
import io.jaegertracing.samplers.Sampler;
import io.jaegertracing.samplers.SamplingManager;
import io.jaegertracing.senders.Sender;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.HashMap;
import java.util.Map;

public class EndToEndBehavior {
    private final Map<String, Tracer> tracers;

    public EndToEndBehavior(Map<String, Tracer> tracers) {
        this.tracers = new HashMap<String, Tracer>(tracers);
    }

    public EndToEndBehavior(String samplingHostPort, String serviceName, Sender sender) {
        Metrics metrics = new Metrics((MetricsFactory)new NoopMetricsFactory());
        RemoteReporter reporter = new RemoteReporter(sender, 1000, 100, metrics);
        ConstSampler constSampler = new ConstSampler(true);
        this.tracers = new HashMap<String, Tracer>();
        this.tracers.put("remote", this.getRemoteTracer(metrics, (Reporter)reporter, serviceName, samplingHostPort));
        this.tracers.put("const", (Tracer)new Tracer.Builder(serviceName, (Reporter)reporter, (Sampler)constSampler).build());
    }

    private Tracer getRemoteTracer(Metrics metrics, Reporter reporter, String serviceName, String samplingHostPort) {
        ProbabilisticSampler initialSampler = new ProbabilisticSampler(1.0);
        HttpSamplingManager manager = new HttpSamplingManager(samplingHostPort);
        RemoteControlledSampler remoteSampler = new RemoteControlledSampler(serviceName, (SamplingManager)manager, (Sampler)initialSampler, metrics, 5000);
        Tracer.Builder remoteTracerBuilder = new Tracer.Builder(serviceName, reporter, (Sampler)remoteSampler);
        return remoteTracerBuilder.build();
    }

    public void generateTraces(CreateTracesRequest request) {
        String samplerType = request.getType();
        Tracer tracer = this.tracers.get(samplerType);
        for (int i = 0; i < request.getCount(); ++i) {
            Tracer.SpanBuilder builder = tracer.buildSpan(request.getOperation());
            if (request.getTags() != null) {
                for (Map.Entry<String, String> kv : request.getTags().entrySet()) {
                    builder.withTag(kv.getKey(), kv.getValue());
                }
            }
            Span span = builder.startManual();
            span.finish();
        }
    }
}

