/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.baggage;

import io.jaegertracing.Span;
import io.jaegertracing.SpanContext;
import io.jaegertracing.baggage.BaggageRestrictionManager;
import io.jaegertracing.baggage.Restriction;
import io.jaegertracing.metrics.Metrics;
import java.util.HashMap;

public class BaggageSetter {
    private final BaggageRestrictionManager restrictionManager;
    private final Metrics metrics;

    public BaggageSetter(BaggageRestrictionManager restrictionManager, Metrics metrics) {
        this.restrictionManager = restrictionManager;
        this.metrics = metrics;
    }

    public SpanContext setBaggage(Span span, String key, String value) {
        Restriction restriction = this.restrictionManager.getRestriction(span.getServiceName(), key);
        boolean truncated = false;
        String prevItem = null;
        if (!restriction.isKeyAllowed()) {
            this.metrics.baggageUpdateFailure.inc(1L);
            this.logFields(span, key, value, prevItem, truncated, restriction.isKeyAllowed());
            return span.context();
        }
        if (value != null && value.length() > restriction.getMaxValueLength()) {
            truncated = true;
            value = value.substring(0, restriction.getMaxValueLength());
            this.metrics.baggageTruncate.inc(1L);
        }
        prevItem = span.getBaggageItem(key);
        this.logFields(span, key, value, prevItem, truncated, restriction.isKeyAllowed());
        this.metrics.baggageUpdateSuccess.inc(1L);
        return span.context().withBaggageItem(key, value);
    }

    private void logFields(Span span, String key, String value, String prevItem, boolean truncated, boolean valid) {
        if (!span.context().isSampled()) {
            return;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("event", "baggage");
        fields.put("key", key);
        fields.put("value", value);
        if (prevItem != null) {
            fields.put("override", "true");
        }
        if (truncated) {
            fields.put("truncated", "true");
        }
        if (!valid) {
            fields.put("invalid", "true");
        }
        span.log(fields);
    }
}

