/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import java.util.HashMap;

public class MimeTypes {
    public static final String TYPE_APPLICATION_JSON = "application/json";
    public static final String TYPE_APPLICATION_ZIP = "application/zip";
    public static final String TYPE_APPLICATION_X_GZIP = "application/x-gzip";
    public static final String TYPE_APPLICATION_TGZ = "application/tgz";
    public static final String TYPE_APPLICATION_MSWORD = "application/msword";
    public static final String TYPE_APPLICATION_POSTSCRIPT = "application/postscript";
    public static final String TYPE_APPLICATION_PDF = "application/pdf";
    public static final String TYPE_APPLICATION_JNLP = "application/jnlp";
    public static final String TYPE_APPLICATION_MAC_BINHEX40 = "application/mac-binhex40";
    public static final String TYPE_APPLICATION_MAC_COMPACTPRO = "application/mac-compactpro";
    public static final String TYPE_APPLICATION_MATHML_XML = "application/mathml+xml";
    public static final String TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String TYPE_APPLICATION_ODA = "application/oda";
    public static final String TYPE_APPLICATION_RDF_XML = "application/rdf+xml";
    public static final String TYPE_APPLICATION_JAVA_ARCHIVE = "application/java-archive";
    public static final String TYPE_APPLICATION_RDF_SMIL = "application/smil";
    public static final String TYPE_APPLICATION_SRGS = "application/srgs";
    public static final String TYPE_APPLICATION_SRGS_XML = "application/srgs+xml";
    public static final String TYPE_APPLICATION_VND_MIF = "application/vnd.mif";
    public static final String TYPE_APPLICATION_VND_MSEXCEL = "application/vnd.ms-excel";
    public static final String TYPE_APPLICATION_VND_MSPOWERPOINT = "application/vnd.ms-powerpoint";
    public static final String TYPE_APPLICATION_VND_RNREALMEDIA = "application/vnd.rn-realmedia";
    public static final String TYPE_APPLICATION_X_BCPIO = "application/x-bcpio";
    public static final String TYPE_APPLICATION_X_CDLINK = "application/x-cdlink";
    public static final String TYPE_APPLICATION_X_CHESS_PGN = "application/x-chess-pgn";
    public static final String TYPE_APPLICATION_X_CPIO = "application/x-cpio";
    public static final String TYPE_APPLICATION_X_CSH = "application/x-csh";
    public static final String TYPE_APPLICATION_X_DIRECTOR = "application/x-director";
    public static final String TYPE_APPLICATION_X_DVI = "application/x-dvi";
    public static final String TYPE_APPLICATION_X_FUTURESPLASH = "application/x-futuresplash";
    public static final String TYPE_APPLICATION_X_GTAR = "application/x-gtar";
    public static final String TYPE_APPLICATION_X_HDF = "application/x-hdf";
    public static final String TYPE_APPLICATION_X_JAVASCRIPT = "application/x-javascript";
    public static final String TYPE_APPLICATION_X_KOAN = "application/x-koan";
    public static final String TYPE_APPLICATION_X_LATEX = "application/x-latex";
    public static final String TYPE_APPLICATION_X_NETCDF = "application/x-netcdf";
    public static final String TYPE_APPLICATION_X_OGG = "application/x-ogg";
    public static final String TYPE_APPLICATION_X_SH = "application/x-sh";
    public static final String TYPE_APPLICATION_X_SHAR = "application/x-shar";
    public static final String TYPE_APPLICATION_X_SHOCKWAVE_FLASH = "application/x-shockwave-flash";
    public static final String TYPE_APPLICATION_X_STUFFIT = "application/x-stuffit";
    public static final String TYPE_APPLICATION_X_SV4CPIO = "application/x-sv4cpio";
    public static final String TYPE_APPLICATION_X_SV4CRC = "application/x-sv4crc";
    public static final String TYPE_APPLICATION_X_TAR = "application/x-tar";
    public static final String TYPE_APPLICATION_X_RAR_COMPRESSED = "application/x-rar-compressed";
    public static final String TYPE_APPLICATION_X_TCL = "application/x-tcl";
    public static final String TYPE_APPLICATION_X_TEX = "application/x-tex";
    public static final String TYPE_APPLICATION_X_TEXINFO = "application/x-texinfo";
    public static final String TYPE_APPLICATION_X_TROFF = "application/x-troff";
    public static final String TYPE_APPLICATION_X_TROFF_MAN = "application/x-troff-man";
    public static final String TYPE_APPLICATION_X_TROFF_ME = "application/x-troff-me";
    public static final String TYPE_APPLICATION_X_TROFF_MS = "application/x-troff-ms";
    public static final String TYPE_APPLICATION_X_USTAR = "application/x-ustar";
    public static final String TYPE_APPLICATION_X_WAIS_SOURCE = "application/x-wais-source";
    public static final String TYPE_APPLICATION_VND_MOZZILLA_XUL_XML = "application/vnd.mozilla.xul+xml";
    public static final String TYPE_APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final String TYPE_APPLICATION_XSLT_XML = "application/xslt+xml";
    public static final String TYPE_APPLICATION_XML = "application/xml";
    public static final String TYPE_APPLICATION_XML_DTD = "application/xml-dtd";
    public static final String TYPE_IMAGE_BMP = "image/bmp";
    public static final String TYPE_IMAGE_CGM = "image/cgm";
    public static final String TYPE_IMAGE_GIF = "image/gif";
    public static final String TYPE_IMAGE_IEF = "image/ief";
    public static final String TYPE_IMAGE_JPEG = "image/jpeg";
    public static final String TYPE_IMAGE_TIFF = "image/tiff";
    public static final String TYPE_IMAGE_PNG = "image/png";
    public static final String TYPE_IMAGE_SVG_XML = "image/svg+xml";
    public static final String TYPE_IMAGE_VND_DJVU = "image/vnd.djvu";
    public static final String TYPE_IMAGE_WAP_WBMP = "image/vnd.wap.wbmp";
    public static final String TYPE_IMAGE_X_CMU_RASTER = "image/x-cmu-raster";
    public static final String TYPE_IMAGE_X_ICON = "image/x-icon";
    public static final String TYPE_IMAGE_X_PORTABLE_ANYMAP = "image/x-portable-anymap";
    public static final String TYPE_IMAGE_X_PORTABLE_BITMAP = "image/x-portable-bitmap";
    public static final String TYPE_IMAGE_X_PORTABLE_GRAYMAP = "image/x-portable-graymap";
    public static final String TYPE_IMAGE_X_PORTABLE_PIXMAP = "image/x-portable-pixmap";
    public static final String TYPE_IMAGE_X_RGB = "image/x-rgb";
    public static final String TYPE_AUDIO_BASIC = "audio/basic";
    public static final String TYPE_AUDIO_MIDI = "audio/midi";
    public static final String TYPE_AUDIO_MPEG = "audio/mpeg";
    public static final String TYPE_AUDIO_X_AIFF = "audio/x-aiff";
    public static final String TYPE_AUDIO_X_MPEGURL = "audio/x-mpegurl";
    public static final String TYPE_AUDIO_X_PN_REALAUDIO = "audio/x-pn-realaudio";
    public static final String TYPE_AUDIO_X_WAV = "audio/x-wav";
    public static final String TYPE_CHEMICAL_X_PDB = "chemical/x-pdb";
    public static final String TYPE_CHEMICAL_X_XYZ = "chemical/x-xyz";
    public static final String TYPE_MODEL_IGES = "model/iges";
    public static final String TYPE_MODEL_MESH = "model/mesh";
    public static final String TYPE_MODEL_VRLM = "model/vrml";
    public static final String TYPE_TEXT_PLAIN = "text/plain";
    public static final String TYPE_TEXT_RICHTEXT = "text/richtext";
    public static final String TYPE_TEXT_RTF = "text/rtf";
    public static final String TYPE_TEXT_HTML = "text/html";
    public static final String TYPE_TEXT_CALENDAR = "text/calendar";
    public static final String TYPE_TEXT_CSS = "text/css";
    public static final String TYPE_TEXT_SGML = "text/sgml";
    public static final String TYPE_TEXT_TAB_SEPARATED_VALUES = "text/tab-separated-values";
    public static final String TYPE_TEXT_VND_WAP_XML = "text/vnd.wap.wml";
    public static final String TYPE_TEXT_VND_WAP_WMLSCRIPT = "text/vnd.wap.wmlscript";
    public static final String TYPE_TEXT_X_SETEXT = "text/x-setext";
    public static final String TYPE_TEXT_X_COMPONENT = "text/x-component";
    public static final String TYPE_VIDEO_QUICKTIME = "video/quicktime";
    public static final String TYPE_VIDEO_MPEG = "video/mpeg";
    public static final String TYPE_VIDEO_VND_MPEGURL = "video/vnd.mpegurl";
    public static final String TYPE_VIDEO_X_MSVIDEO = "video/x-msvideo";
    public static final String TYPE_VIDEO_X_MS_WMV = "video/x-ms-wmv";
    public static final String TYPE_VIDEO_X_SGI_MOVIE = "video/x-sgi-movie";
    public static final String TYPE_X_CONFERENCE_X_COOLTALK = "x-conference/x-cooltalk";
    private static HashMap<String, String> mimeTypes = new HashMap();

    public static void withMimeType(String ext, String mimeType) {
        mimeTypes.put(ext.toLowerCase(), mimeType);
    }

    public static String getMimeType(String ext) {
        return mimeTypes.get(ext.toLowerCase());
    }

    static {
        MimeTypes.withMimeType("xul", TYPE_APPLICATION_VND_MOZZILLA_XUL_XML);
        MimeTypes.withMimeType("json", TYPE_APPLICATION_JSON);
        MimeTypes.withMimeType("ice", TYPE_X_CONFERENCE_X_COOLTALK);
        MimeTypes.withMimeType("movie", TYPE_VIDEO_X_SGI_MOVIE);
        MimeTypes.withMimeType("avi", TYPE_VIDEO_X_MSVIDEO);
        MimeTypes.withMimeType("wmv", TYPE_VIDEO_X_MS_WMV);
        MimeTypes.withMimeType("m4u", TYPE_VIDEO_VND_MPEGURL);
        MimeTypes.withMimeType("mxu", TYPE_VIDEO_VND_MPEGURL);
        MimeTypes.withMimeType("htc", TYPE_TEXT_X_COMPONENT);
        MimeTypes.withMimeType("etx", TYPE_TEXT_X_SETEXT);
        MimeTypes.withMimeType("wmls", TYPE_TEXT_VND_WAP_WMLSCRIPT);
        MimeTypes.withMimeType("wml", TYPE_TEXT_VND_WAP_XML);
        MimeTypes.withMimeType("tsv", TYPE_TEXT_TAB_SEPARATED_VALUES);
        MimeTypes.withMimeType("sgm", TYPE_TEXT_SGML);
        MimeTypes.withMimeType("sgml", TYPE_TEXT_SGML);
        MimeTypes.withMimeType("css", TYPE_TEXT_CSS);
        MimeTypes.withMimeType("ifb", TYPE_TEXT_CALENDAR);
        MimeTypes.withMimeType("ics", TYPE_TEXT_CALENDAR);
        MimeTypes.withMimeType("wrl", TYPE_MODEL_VRLM);
        MimeTypes.withMimeType("vrlm", TYPE_MODEL_VRLM);
        MimeTypes.withMimeType("silo", TYPE_MODEL_MESH);
        MimeTypes.withMimeType("mesh", TYPE_MODEL_MESH);
        MimeTypes.withMimeType("msh", TYPE_MODEL_MESH);
        MimeTypes.withMimeType("iges", TYPE_MODEL_IGES);
        MimeTypes.withMimeType("igs", TYPE_MODEL_IGES);
        MimeTypes.withMimeType("rgb", TYPE_IMAGE_X_RGB);
        MimeTypes.withMimeType("ppm", TYPE_IMAGE_X_PORTABLE_PIXMAP);
        MimeTypes.withMimeType("pgm", TYPE_IMAGE_X_PORTABLE_GRAYMAP);
        MimeTypes.withMimeType("pbm", TYPE_IMAGE_X_PORTABLE_BITMAP);
        MimeTypes.withMimeType("pnm", TYPE_IMAGE_X_PORTABLE_ANYMAP);
        MimeTypes.withMimeType("ico", TYPE_IMAGE_X_ICON);
        MimeTypes.withMimeType("ras", TYPE_IMAGE_X_CMU_RASTER);
        MimeTypes.withMimeType("wbmp", TYPE_IMAGE_WAP_WBMP);
        MimeTypes.withMimeType("djv", TYPE_IMAGE_VND_DJVU);
        MimeTypes.withMimeType("djvu", TYPE_IMAGE_VND_DJVU);
        MimeTypes.withMimeType("svg", TYPE_IMAGE_SVG_XML);
        MimeTypes.withMimeType("ief", TYPE_IMAGE_IEF);
        MimeTypes.withMimeType("cgm", TYPE_IMAGE_CGM);
        MimeTypes.withMimeType("bmp", TYPE_IMAGE_BMP);
        MimeTypes.withMimeType("xyz", TYPE_CHEMICAL_X_XYZ);
        MimeTypes.withMimeType("pdb", TYPE_CHEMICAL_X_PDB);
        MimeTypes.withMimeType("ra", TYPE_AUDIO_X_PN_REALAUDIO);
        MimeTypes.withMimeType("ram", TYPE_AUDIO_X_PN_REALAUDIO);
        MimeTypes.withMimeType("m3u", TYPE_AUDIO_X_MPEGURL);
        MimeTypes.withMimeType("aifc", TYPE_AUDIO_X_AIFF);
        MimeTypes.withMimeType("aif", TYPE_AUDIO_X_AIFF);
        MimeTypes.withMimeType("aiff", TYPE_AUDIO_X_AIFF);
        MimeTypes.withMimeType("mp3", TYPE_AUDIO_MPEG);
        MimeTypes.withMimeType("mp2", TYPE_AUDIO_MPEG);
        MimeTypes.withMimeType("mp1", TYPE_AUDIO_MPEG);
        MimeTypes.withMimeType("mpga", TYPE_AUDIO_MPEG);
        MimeTypes.withMimeType("kar", TYPE_AUDIO_MIDI);
        MimeTypes.withMimeType("mid", TYPE_AUDIO_MIDI);
        MimeTypes.withMimeType("midi", TYPE_AUDIO_MIDI);
        MimeTypes.withMimeType("dtd", TYPE_APPLICATION_XML_DTD);
        MimeTypes.withMimeType("xsl", TYPE_APPLICATION_XML);
        MimeTypes.withMimeType("xml", TYPE_APPLICATION_XML);
        MimeTypes.withMimeType("xslt", TYPE_APPLICATION_XSLT_XML);
        MimeTypes.withMimeType("xht", TYPE_APPLICATION_XHTML_XML);
        MimeTypes.withMimeType("xhtml", TYPE_APPLICATION_XHTML_XML);
        MimeTypes.withMimeType("src", TYPE_APPLICATION_X_WAIS_SOURCE);
        MimeTypes.withMimeType("ustar", TYPE_APPLICATION_X_USTAR);
        MimeTypes.withMimeType("ms", TYPE_APPLICATION_X_TROFF_MS);
        MimeTypes.withMimeType("me", TYPE_APPLICATION_X_TROFF_ME);
        MimeTypes.withMimeType("man", TYPE_APPLICATION_X_TROFF_MAN);
        MimeTypes.withMimeType("roff", TYPE_APPLICATION_X_TROFF);
        MimeTypes.withMimeType("tr", TYPE_APPLICATION_X_TROFF);
        MimeTypes.withMimeType("t", TYPE_APPLICATION_X_TROFF);
        MimeTypes.withMimeType("texi", TYPE_APPLICATION_X_TEXINFO);
        MimeTypes.withMimeType("texinfo", TYPE_APPLICATION_X_TEXINFO);
        MimeTypes.withMimeType("tex", TYPE_APPLICATION_X_TEX);
        MimeTypes.withMimeType("tcl", TYPE_APPLICATION_X_TCL);
        MimeTypes.withMimeType("sv4crc", TYPE_APPLICATION_X_SV4CRC);
        MimeTypes.withMimeType("sv4cpio", TYPE_APPLICATION_X_SV4CPIO);
        MimeTypes.withMimeType("sit", TYPE_APPLICATION_X_STUFFIT);
        MimeTypes.withMimeType("swf", TYPE_APPLICATION_X_SHOCKWAVE_FLASH);
        MimeTypes.withMimeType("shar", TYPE_APPLICATION_X_SHAR);
        MimeTypes.withMimeType("sh", TYPE_APPLICATION_X_SH);
        MimeTypes.withMimeType("cdf", TYPE_APPLICATION_X_NETCDF);
        MimeTypes.withMimeType("nc", TYPE_APPLICATION_X_NETCDF);
        MimeTypes.withMimeType("latex", TYPE_APPLICATION_X_LATEX);
        MimeTypes.withMimeType("skm", TYPE_APPLICATION_X_KOAN);
        MimeTypes.withMimeType("skt", TYPE_APPLICATION_X_KOAN);
        MimeTypes.withMimeType("skd", TYPE_APPLICATION_X_KOAN);
        MimeTypes.withMimeType("skp", TYPE_APPLICATION_X_KOAN);
        MimeTypes.withMimeType("js", TYPE_APPLICATION_X_JAVASCRIPT);
        MimeTypes.withMimeType("hdf", TYPE_APPLICATION_X_HDF);
        MimeTypes.withMimeType("gtar", TYPE_APPLICATION_X_GTAR);
        MimeTypes.withMimeType("spl", TYPE_APPLICATION_X_FUTURESPLASH);
        MimeTypes.withMimeType("dvi", TYPE_APPLICATION_X_DVI);
        MimeTypes.withMimeType("dxr", TYPE_APPLICATION_X_DIRECTOR);
        MimeTypes.withMimeType("dir", TYPE_APPLICATION_X_DIRECTOR);
        MimeTypes.withMimeType("dcr", TYPE_APPLICATION_X_DIRECTOR);
        MimeTypes.withMimeType("csh", TYPE_APPLICATION_X_CSH);
        MimeTypes.withMimeType("cpio", TYPE_APPLICATION_X_CPIO);
        MimeTypes.withMimeType("pgn", TYPE_APPLICATION_X_CHESS_PGN);
        MimeTypes.withMimeType("vcd", TYPE_APPLICATION_X_CDLINK);
        MimeTypes.withMimeType("bcpio", TYPE_APPLICATION_X_BCPIO);
        MimeTypes.withMimeType("rm", TYPE_APPLICATION_VND_RNREALMEDIA);
        MimeTypes.withMimeType("ppt", TYPE_APPLICATION_VND_MSPOWERPOINT);
        MimeTypes.withMimeType("mif", TYPE_APPLICATION_VND_MIF);
        MimeTypes.withMimeType("grxml", TYPE_APPLICATION_SRGS_XML);
        MimeTypes.withMimeType("gram", TYPE_APPLICATION_SRGS);
        MimeTypes.withMimeType("smil", TYPE_APPLICATION_RDF_SMIL);
        MimeTypes.withMimeType("smi", TYPE_APPLICATION_RDF_SMIL);
        MimeTypes.withMimeType("rdf", TYPE_APPLICATION_RDF_XML);
        MimeTypes.withMimeType("ogg", TYPE_APPLICATION_X_OGG);
        MimeTypes.withMimeType("oda", TYPE_APPLICATION_ODA);
        MimeTypes.withMimeType("dmg", TYPE_APPLICATION_OCTET_STREAM);
        MimeTypes.withMimeType("lzh", TYPE_APPLICATION_OCTET_STREAM);
        MimeTypes.withMimeType("so", TYPE_APPLICATION_OCTET_STREAM);
        MimeTypes.withMimeType("lha", TYPE_APPLICATION_OCTET_STREAM);
        MimeTypes.withMimeType("dms", TYPE_APPLICATION_OCTET_STREAM);
        MimeTypes.withMimeType("bin", TYPE_APPLICATION_OCTET_STREAM);
        MimeTypes.withMimeType("mathml", TYPE_APPLICATION_MATHML_XML);
        MimeTypes.withMimeType("cpt", TYPE_APPLICATION_MAC_COMPACTPRO);
        MimeTypes.withMimeType("hqx", TYPE_APPLICATION_MAC_BINHEX40);
        MimeTypes.withMimeType("jnlp", TYPE_APPLICATION_JNLP);
        MimeTypes.withMimeType("txt", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("ini", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("c", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("h", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("cpp", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("cxx", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("cc", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("chh", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("java", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("csv", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("bat", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("cmd", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("asc", TYPE_TEXT_PLAIN);
        MimeTypes.withMimeType("rtf", TYPE_TEXT_RTF);
        MimeTypes.withMimeType("rtx", TYPE_TEXT_RICHTEXT);
        MimeTypes.withMimeType("html", TYPE_TEXT_HTML);
        MimeTypes.withMimeType("htm", TYPE_TEXT_HTML);
        MimeTypes.withMimeType("zip", TYPE_APPLICATION_ZIP);
        MimeTypes.withMimeType("rar", TYPE_APPLICATION_X_RAR_COMPRESSED);
        MimeTypes.withMimeType("gzip", TYPE_APPLICATION_X_GZIP);
        MimeTypes.withMimeType("gz", TYPE_APPLICATION_X_GZIP);
        MimeTypes.withMimeType("tgz", TYPE_APPLICATION_TGZ);
        MimeTypes.withMimeType("tar", TYPE_APPLICATION_X_TAR);
        MimeTypes.withMimeType("gif", TYPE_IMAGE_GIF);
        MimeTypes.withMimeType("jpeg", TYPE_IMAGE_JPEG);
        MimeTypes.withMimeType("jpg", TYPE_IMAGE_JPEG);
        MimeTypes.withMimeType("jpe", TYPE_IMAGE_JPEG);
        MimeTypes.withMimeType("tiff", TYPE_IMAGE_TIFF);
        MimeTypes.withMimeType("tif", TYPE_IMAGE_TIFF);
        MimeTypes.withMimeType("png", TYPE_IMAGE_PNG);
        MimeTypes.withMimeType("au", TYPE_AUDIO_BASIC);
        MimeTypes.withMimeType("snd", TYPE_AUDIO_BASIC);
        MimeTypes.withMimeType("wav", TYPE_AUDIO_X_WAV);
        MimeTypes.withMimeType("mov", TYPE_VIDEO_QUICKTIME);
        MimeTypes.withMimeType("qt", TYPE_VIDEO_QUICKTIME);
        MimeTypes.withMimeType("mpeg", TYPE_VIDEO_MPEG);
        MimeTypes.withMimeType("mpg", TYPE_VIDEO_MPEG);
        MimeTypes.withMimeType("mpe", TYPE_VIDEO_MPEG);
        MimeTypes.withMimeType("abs", TYPE_VIDEO_MPEG);
        MimeTypes.withMimeType("doc", TYPE_APPLICATION_MSWORD);
        MimeTypes.withMimeType("xls", TYPE_APPLICATION_VND_MSEXCEL);
        MimeTypes.withMimeType("eps", TYPE_APPLICATION_POSTSCRIPT);
        MimeTypes.withMimeType("ai", TYPE_APPLICATION_POSTSCRIPT);
        MimeTypes.withMimeType("ps", TYPE_APPLICATION_POSTSCRIPT);
        MimeTypes.withMimeType("pdf", TYPE_APPLICATION_PDF);
        MimeTypes.withMimeType("exe", TYPE_APPLICATION_OCTET_STREAM);
        MimeTypes.withMimeType("dll", TYPE_APPLICATION_OCTET_STREAM);
        MimeTypes.withMimeType("class", TYPE_APPLICATION_OCTET_STREAM);
        MimeTypes.withMimeType("jar", TYPE_APPLICATION_JAVA_ARCHIVE);
    }
}

