/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Rows
extends ArrayList<Row> {
    RowKeys keys = null;
    Row lastRow = null;

    public Rows() {
        this.keys = new RowKeys();
    }

    public Rows(Map row) {
        this.addRow(row);
    }

    public Rows(String[] keys) {
        this.keys = new RowKeys(Arrays.asList(keys));
    }

    public Rows(List<String> keys) {
        this.keys = new RowKeys(keys);
    }

    public List<String> keyList() {
        return new ArrayList<String>(this.keys.keys);
    }

    public Set<String> keySet() {
        return this.keys.keySet();
    }

    public int addKey(String key) {
        return this.keys.addKey(key);
    }

    public Row addRow() {
        this.lastRow = new Row(this.keys);
        super.add(this.lastRow);
        return this.lastRow;
    }

    public Row addRow(Map map) {
        return this.addRow(-1, map);
    }

    public Row addRow(int index, Map map) {
        if (this.keys == null || this.keys.size() == 0) {
            this.keys = new RowKeys(new ArrayList<String>(map.keySet()));
        }
        ArrayList arr = new ArrayList(this.keys.keys.size());
        for (int i = 0; i < this.keys.keys.size(); ++i) {
            Object value = map.get(this.keys.keys.get(i));
            arr.add(value);
        }
        return this.addRow(index, arr.toArray());
    }

    public Row addRow(List values) {
        return this.addRow(-1, values.toArray());
    }

    public Row addRow(int index, List values) {
        return this.addRow(index, values.toArray());
    }

    public Row addRow(Object[] values) {
        return this.addRow(-1, values);
    }

    public Row addRow(int index, Object[] values) {
        this.lastRow = new Row(this.keys, values);
        if (index > -1) {
            super.add(index, this.lastRow);
        } else {
            super.add(this.lastRow);
        }
        return this.lastRow;
    }

    public void put(String key, Object value) {
        this.lastRow.put(key, value);
    }

    public void put(Object value) {
        this.lastRow.add(value);
    }

    @Override
    public boolean add(Row row) {
        this.addRow(row);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Row> rows) {
        for (Row row : rows) {
            this.addRow(row);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Row> rows) {
        for (Row row : rows) {
            this.addRow(index, row);
        }
        return true;
    }

    protected static class RowKeys {
        List<String> keys = new ArrayList<String>();
        Map<String, Integer> lc = new HashMap<String, Integer>();
        Set<String> cachedKeySet = null;

        RowKeys() {
        }

        RowKeys(List<String> keys) {
            this.setKeys(keys);
        }

        public RowKeys copy() {
            RowKeys clone = new RowKeys();
            clone.keys = new LinkedList<String>(this.keys);
            clone.lc = new HashMap<String, Integer>(this.lc);
            return clone;
        }

        int addKey(String key) {
            this.cachedKeySet = null;
            if (key == null) {
                return -1;
            }
            String lc = key.toLowerCase();
            Integer existing = this.lc.get(lc);
            if (existing != null) {
                return existing;
            }
            this.keys.add(key);
            this.lc.put(lc, this.keys.size() - 1);
            return this.keys.size() - 1;
        }

        int removeKey(String key) {
            this.cachedKeySet = null;
            Integer idx = this.lc.get(key = key.toLowerCase());
            if (idx != null) {
                int i;
                for (i = idx.intValue(); i < this.keys.size(); ++i) {
                    this.lc.remove(this.keys.get(i).toLowerCase());
                }
                this.keys.remove(idx);
                for (i = idx.intValue(); i < this.keys.size(); ++i) {
                    this.lc.put(this.keys.get(i).toLowerCase(), i);
                }
                return idx;
            }
            return -1;
        }

        void setKeys(List<String> keys) {
            this.cachedKeySet = null;
            this.keys.clear();
            this.lc.clear();
            for (String key : keys) {
                this.addKey(key);
            }
        }

        int indexOf(String key) {
            if (key == null) {
                return -1;
            }
            Integer idx = this.lc.get(key.toLowerCase());
            if (idx != null) {
                return idx;
            }
            return -1;
        }

        int size() {
            return this.keys.size();
        }

        String getKey(int index) {
            return this.keys.get(index);
        }

        Set<String> keySet() {
            if (this.cachedKeySet == null) {
                this.cachedKeySet = new LinkedHashSet<String>(this.keys);
            }
            return this.cachedKeySet;
        }
    }

    public static class Row
    implements Map<String, Object> {
        final List<Object> values;
        RowKeys keys;
        boolean cloned = false;

        public Row() {
            this.keys = new RowKeys();
            this.values = new ArrayList<Object>();
        }

        Row(RowKeys keys) {
            this.keys = keys;
            this.values = new ArrayList<Object>(keys.size());
        }

        Row(RowKeys keys, Object[] values) {
            this.keys = keys;
            this.values = new ArrayList<Object>(Arrays.asList(values));
        }

        public String getKey(int index) {
            return this.keys.getKey(index);
        }

        public String getString(int index) {
            Object value = this.get(index);
            if (value != null) {
                return value.toString();
            }
            return null;
        }

        public String getString(String key) {
            Object value = this.get(key);
            if (value != null) {
                return value.toString();
            }
            return null;
        }

        public int getInt(int index) {
            Object value = this.get(index);
            if (value != null) {
                return Integer.parseInt(value.toString());
            }
            return -1;
        }

        public int getInt(String key) {
            Object value = this.get(key);
            if (value != null) {
                return Integer.parseInt(value.toString());
            }
            return -1;
        }

        public long getLong(int index) {
            Object value = this.get(index);
            if (value != null) {
                return Long.parseLong(value.toString());
            }
            return -1L;
        }

        public long getLong(String key) {
            Object value = this.get(key);
            if (value != null) {
                return Long.parseLong(value.toString());
            }
            return -1L;
        }

        public float getFloat(int index) {
            Object value = this.get(index);
            if (value != null) {
                return Float.parseFloat(value.toString());
            }
            return -1.0f;
        }

        public float getFloat(String key) {
            Object value = this.get(key);
            if (value != null) {
                return Float.parseFloat(value.toString());
            }
            return -1.0f;
        }

        public boolean getBoolean(int index) {
            Object value = this.get(index);
            if (value != null) {
                return value.toString().toLowerCase().startsWith("t") || value.toString().equals("1");
            }
            return false;
        }

        public boolean getBoolean(String key) {
            Object value = this.get(key);
            if (value != null) {
                return value.toString().toLowerCase().startsWith("t") || value.toString().equals("1");
            }
            return false;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder("{");
            for (int i = 0; i < this.keys.size(); ++i) {
                buff.append(this.keys.getKey(i)).append("=").append(this.values.get(i));
                if (i >= this.keys.size() - 1) continue;
                buff.append(", ");
            }
            buff.append("}");
            return buff.toString();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.indexOf((String)key) >= 0;
        }

        public int indexOf(String key) {
            return this.keys.indexOf(key);
        }

        @Override
        public boolean containsValue(Object value) {
            for (Object v : this.values) {
                if (v == null && value == null) {
                    return true;
                }
                if (v == null || !v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Object get(String key) {
            int idx = this.indexOf(key);
            if (idx >= 0) {
                return this.values.get(idx);
            }
            return null;
        }

        public Object get(int index) throws ArrayIndexOutOfBoundsException {
            return this.values.get(index);
        }

        @Override
        public Object get(Object keyOrIndex) {
            if (keyOrIndex == null) {
                return null;
            }
            int idx = keyOrIndex instanceof String ? this.keys.indexOf((String)keyOrIndex) : ((Integer)keyOrIndex).intValue();
            if (idx < 0 || idx >= this.size()) {
                return null;
            }
            return this.values.get(idx);
        }

        public void set(int index, Object value) {
            this.values.set(index, value);
        }

        public void add(Object value) {
            this.values.add(value);
        }

        @Override
        public Object put(String key, Object value) {
            int idx = this.keys.indexOf(key);
            if (idx >= 0) {
                while (idx > this.values.size() - 1) {
                    this.values.add(null);
                }
                return this.values.set(idx, value);
            }
            this.keys.addKey(key);
            this.values.add(value);
            return value;
        }

        @Override
        public Object remove(Object key) {
            int idx = this.keys.indexOf((String)key);
            if (idx >= 0) {
                if (!this.cloned) {
                    this.cloned = true;
                    this.keys = this.keys.copy();
                }
                Object value = this.values.get(idx);
                this.keys.removeKey((String)key);
                this.values.remove(idx);
                return value;
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            for (String string : m.keySet()) {
                this.put(string, m.get(string));
            }
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.values.size(); ++i) {
                this.values.set(i, null);
            }
        }

        @Override
        public Set<String> keySet() {
            return this.keys.keySet();
        }

        @Override
        public Collection<Object> values() {
            return Collections.unmodifiableList(this.values);
        }

        public List<Object> asList() {
            return Collections.unmodifiableList(this.values);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            LinkedHashSet<Map.Entry<String, Object>> entries = new LinkedHashSet<Map.Entry<String, Object>>();
            for (int i = 0; i < this.keys.size(); ++i) {
                entries.add(new E(this.keys.getKey(i), this.values.get(i)));
            }
            return entries;
        }

        static class E
        implements Map.Entry<String, Object> {
            String key;
            Object value;

            public E(String key, Object value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            @Override
            public Object getValue() {
                return this.value;
            }

            @Override
            public Object setValue(Object value) {
                Object v = this.value;
                this.value = value;
                return v;
            }
        }
    }
}

