package io.intercom.android.nexus;

import java.util.HashMap;

public class EventData extends HashMap<String, Object> {

    public EventData() {
        super();
    }

    public EventData(int initialCapacity) {
        super(initialCapacity);
    }

    public String optString(String key) {
        return optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object value = get(key);
        return (value instanceof String) ? (String) value : defaultValue;
    }

    public long optLong(String key) {
        return optLong(key, -1);
    }

    public long optLong(String key, long defaultValue) {
        Object value = get(key);
        return (value instanceof Long) ? (long) value : defaultValue;
    }

}
