/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.user;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import io.intercom.android.sdk.utilities.DeviceUtils;
import java.util.HashMap;
import java.util.Locale;

public class DeviceData {
    public static HashMap<String, Object> generateDeviceData(Context context) {
        HashMap<String, Object> deviceData = new HashMap<String, Object>();
        deviceData.put("platform_version", Build.VERSION.RELEASE);
        deviceData.put("device", Build.CPU_ABI);
        deviceData.put("platform", Build.MODEL);
        deviceData.put("browser", "Intercom-Android-SDK");
        deviceData.put("version", DeviceData.getAppVersion(context));
        deviceData.put("application", DeviceData.getAppName(context));
        deviceData.put("language", Locale.getDefault().getDisplayLanguage());
        deviceData.put("device_id", DeviceUtils.generateDeviceId(context));
        return deviceData;
    }

    private static String getAppVersion(Context context) {
        String version = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            version = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }

    private static String getAppName(Context context) {
        String name = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            name = packageInfo.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return name;
    }
}

