/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.os.Bundle;
import io.intercom.android.blocks.BlockType;
import io.intercom.android.blocks.Blocks;
import io.intercom.android.blocks.BlocksViewHolder;
import io.intercom.android.blocks.models.Block;
import io.intercom.android.blocks.models.BlockAttachment;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.blocks.LightWeightReply;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.conversation.ConversationAdapter;
import io.intercom.android.sdk.interfaces.LWRListener;
import io.intercom.android.sdk.interfaces.OnConversationInteractionListener;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Events.CloseIAMEvent;
import io.intercom.android.sdk.models.api.LWR;
import io.intercom.android.sdk.models.api.Participant;
import io.intercom.android.sdk.models.api.response.Part;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=15)
public abstract class BaseConversationFragment
extends Fragment
implements LWRListener {
    protected OnConversationInteractionListener listener;
    protected String conversationId;
    protected boolean allowTextReply;
    protected ViewHolderGenerator generator;
    protected ConversationAdapter adapter;
    protected Blocks blocks;
    protected List<Part> conversationParts;
    private BlocksViewHolder blocksUserViewHolder;
    private BlocksViewHolder blocksAnnouncementViewHolder;
    private BlocksViewHolder blocksAdminViewHolder;
    private BlocksViewHolder blocksLWRViewHolder;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.listener = (OnConversationInteractionListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity + " must implement OnConversationInteractionListener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bridge.init(this.getActivity().getApplicationContext());
        this.conversationParts = new ArrayList<Part>();
        this.generator = new ViewHolderGenerator(this.getActivity().getApplicationContext());
        this.blocksUserViewHolder = this.generator.getUserHolder();
        this.blocksAnnouncementViewHolder = this.generator.getAnnouncementHolder();
        this.blocksAdminViewHolder = this.generator.getAdminHolder(this);
        this.blocksLWRViewHolder = this.generator.getAnnouncementLWRHolder(this);
    }

    protected Part createMessageUI(Part part) {
        Participant user = part.getParticipant();
        List<Block> blockParts = part.getBlocks();
        if (!part.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : part.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).build());
            }
            Block attachmentBlock = new Block.Builder().withType(BlockType.attachmentList.name()).withAttachments(blockAttachments).build();
            blockParts.add(attachmentBlock);
        }
        if (!(part.getLightweightReply() instanceof LWR.NullLWR)) {
            Block lwrBlock = new Block.Builder().withType(BlockType.lwr.name()).withText(part.getLightweightReply().getType()).build();
            blockParts.add(lwrBlock);
            LightWeightReply announcementLWR = (LightWeightReply)this.blocksLWRViewHolder.getLwr();
            announcementLWR.setLwrObject(part.getLightweightReply());
            LightWeightReply adminLWR = (LightWeightReply)this.blocksAdminViewHolder.getLwr();
            adminLWR.setLwrObject(part.getLightweightReply());
            this.allowTextReply = false;
        } else {
            this.allowTextReply = true;
        }
        if (!blockParts.isEmpty()) {
            if ("user".equals(user.getType()) && user.getId().equals(Bridge.getIdentityStore().getIntercomId())) {
                part.setLayout(this.blocks.createBlocks(blockParts, this.blocksUserViewHolder));
            } else if ("announcement".equals(part.getMessageStyle()) || "small-announcement".equals(part.getMessageStyle())) {
                if (this.allowTextReply) {
                    part.setLayout(this.blocks.createBlocks(blockParts, this.blocksAnnouncementViewHolder));
                } else {
                    part.setLayout(this.blocks.createBlocks(blockParts, this.blocksLWRViewHolder));
                }
            } else {
                part.setLayout(this.blocks.createBlocks(blockParts, this.blocksAdminViewHolder));
            }
        }
        return part;
    }

    @Override
    public void sendLWRResponse(LWR lwr) {
        Bridge.getApi().sendLWRResponse(this.conversationId, lwr.getType(), lwr.getOption());
    }

    protected void markAsRead() {
        Bridge.getApi().markConversationAsRead(this.conversationId);
    }

    protected void closeTapped() {
        Bridge.getBus().post((Object)new CloseIAMEvent());
    }
}

