/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.text.Html;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.blocks.blockInterfaces.UnorderedListBlock;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.spans.UnorderedListSpan;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import java.util.List;

public class UnorderedList
implements UnorderedListBlock {
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Context context;

    public UnorderedList(Context context, StyleType style) {
        this.context = context;
        this.style = style;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addUnorderedList(List<String> items, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        LinearLayout layout2 = new LinearLayout(this.context);
        switch (this.style) {
            case ADMIN: 
            case ANNOUNCEMENT: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_unorderedlist, parent, false);
                break;
            }
            case WELCOME: {
                layout2 = (LinearLayout)this.inflater.inflate(R.layout.intercomsdk_blocks_welcome_list, parent, false);
                textview = (TextView)layout2.findViewById(R.id.list);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_user_unorderedlist, parent, false);
            }
        }
        int lineIndent = (int)this.context.getResources().getDimension(R.dimen.intercomsdk_list_indentation);
        CharSequence chars = "";
        for (String item : items) {
            if (item.isEmpty()) continue;
            SpannableString s = new SpannableString((CharSequence)Html.fromHtml((String)(item + "<br />")));
            s.setSpan((Object)new UnorderedListSpan(lineIndent, this.context), 0, item.length(), 0);
            chars = TextUtils.concat((CharSequence[])new CharSequence[]{chars, s});
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        textview.setText(chars);
        BlockUtils.setLayoutMarginsAndGravity((View)textview, 3, isLastObject);
        if (StyleType.WELCOME == this.style) {
            return layout2;
        }
        textview.setLinkTextColor(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
        return textview;
    }
}

