/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.models.APIModels.BaseResponse;
import io.intercom.android.sdk.models.APIModels.Conversation;
import io.intercom.android.sdk.models.APIModels.ConversationsResponse;
import io.intercom.android.sdk.models.APIModels.Part;
import io.intercom.android.sdk.models.APIModels.ReadResponse;
import io.intercom.android.sdk.models.APIModels.UsersResponse;
import io.intercom.android.sdk.models.Config;
import io.intercom.android.sdk.models.Events.ConversationEvent;
import io.intercom.android.sdk.models.Events.Failure.InboxFailedEvent;
import io.intercom.android.sdk.models.Events.Failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.Events.Failure.ReplyFailedEvent;
import io.intercom.android.sdk.models.Events.InboxEvent;
import io.intercom.android.sdk.models.Events.NewConversationEvent;
import io.intercom.android.sdk.models.Events.ReadEvent;
import io.intercom.android.sdk.models.Events.ReplyEvent;
import io.intercom.android.sdk.models.Events.UnreadConversationsEvent;
import io.intercom.android.sdk.models.User;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class CallbackHolder {
    public Callback<ReadResponse.Builder> readCallback(final String conversationId) {
        return new Callback<ReadResponse.Builder>(){

            public void success(ReadResponse.Builder builder, Response r) {
                ReadResponse response = builder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
                Bridge.getBus().post((Object)new ReadEvent(conversationId));
            }

            public void failure(RetrofitError error) {
            }
        };
    }

    public Callback<UsersResponse.Builder> unreadCallback() {
        return new Callback<UsersResponse.Builder>(){

            public void success(UsersResponse.Builder responseBuilder, Response r) {
                UsersResponse response = responseBuilder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
                Bridge.getBus().post((Object)new UnreadConversationsEvent(response.getUnreadConversations()));
            }

            public void failure(RetrofitError error) {
            }
        };
    }

    public Callback<ConversationsResponse.Builder> inboxCallback() {
        return new Callback<ConversationsResponse.Builder>(){

            public void success(ConversationsResponse.Builder builder, Response r) {
                ConversationsResponse response = builder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
                Bridge.getBus().post((Object)new InboxEvent(response.getConversationPage()));
            }

            public void failure(RetrofitError error) {
                Bridge.getBus().post((Object)new InboxFailedEvent());
            }
        };
    }

    public Callback<Part.Builder> replyCallback(final int position, final String partId, final String conversationId) {
        return new Callback<Part.Builder>(){

            public void success(Part.Builder builder, Response r) {
                Bridge.getBus().post((Object)new ReplyEvent(builder.build(), position, partId, conversationId));
            }

            public void failure(RetrofitError error) {
                Bridge.getBus().post((Object)new ReplyFailedEvent(position, partId));
            }
        };
    }

    public Callback<Conversation.Builder> conversationCallback() {
        return new Callback<Conversation.Builder>(){

            public void success(Conversation.Builder builder, Response response) {
                Bridge.getBus().post((Object)new ConversationEvent(builder.build()));
            }

            public void failure(RetrofitError error) {
            }
        };
    }

    public Callback<Conversation.Builder> newConversationCallback(final int position, final String partId) {
        return new Callback<Conversation.Builder>(){

            public void success(Conversation.Builder builder, Response response) {
                Bridge.getBus().post((Object)new NewConversationEvent(builder.build(), partId));
            }

            public void failure(RetrofitError error) {
                Bridge.getBus().post((Object)new NewConversationFailedEvent(position, partId));
            }
        };
    }

    private void updateBaseResponseObjects(BaseResponse response) {
        this.updateIdentityStore(response.getUser());
        this.updateAppConfig(response.getConfig());
    }

    private void updateIdentityStore(User user) {
        Bridge.getIdentityStore().setUser(user);
    }

    private void updateAppConfig(Config config) {
        Bridge.getIdentityStore().setAppConfig(config);
    }
}

