/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.activities.MainActivity;
import io.intercom.android.sdk.preview.PreviewService;
import io.intercom.android.sdk.utilities.DeviceUtils;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=15)
class Lifecycles
implements Application.ActivityLifecycleCallbacks {
    private static final int SESSION_TIMEOUT = 20000;
    private final Set<String> mAttachedActivities = new HashSet<String>();
    private boolean hasBeenBackgrounded = false;
    private long enteredBackgroundAt = 0L;

    Lifecycles() {
    }

    private static boolean isScreenLocked() {
        KeyguardManager keyguardManager = (KeyguardManager)Bridge.getContext().getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    private void startChatHeadService() {
        if (DeviceUtils.isMessagingSDKSupported(Build.VERSION.SDK_INT)) {
            Context context = Bridge.getContext();
            Intent intent = new Intent(context, PreviewService.class);
            context.startService(intent);
            Bridge.getNexusClient().connect(Bridge.getIdentityStore().getAppConfig().getRealTimeConfig(), true);
        }
    }

    private void killChathead() {
        Context context = Bridge.getContext();
        Intent intent = new Intent(context, PreviewService.class);
        context.stopService(intent);
        Bridge.getNexusClient().disconnect();
    }

    private void attachActivity(Activity activity) {
        this.mAttachedActivities.add(activity.getClass().getName());
    }

    private void detachActivity(Activity activity) {
        this.mAttachedActivities.remove(activity.getClass().getName());
    }

    private boolean isApplicationInBackground(Activity activity) {
        if (Lifecycles.isScreenLocked()) {
            return true;
        }
        boolean configurationChanged = activity.isChangingConfigurations();
        return this.mAttachedActivities.isEmpty() && !configurationChanged;
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        Bridge.init(activity.getApplicationContext());
    }

    public void onActivityStarted(Activity activity) {
        Bridge.init(activity.getApplicationContext());
        this.attachActivity(activity);
        if (!(activity instanceof MainActivity)) {
            this.startChatHeadService();
        }
        Bridge.pingAndLaunchChathead();
        if (this.hasBeenBackgrounded) {
            if (System.currentTimeMillis() - this.enteredBackgroundAt > 20000L) {
                Bridge.getApi().ping();
            }
            this.hasBeenBackgrounded = false;
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityResumed(Activity activity) {
        Bridge.init(activity.getApplicationContext());
        this.attachActivity(activity);
    }

    public void onActivityPaused(Activity activity) {
        this.detachActivity(activity);
    }

    public void onActivityStopped(Activity activity) {
        if (this.isApplicationInBackground(activity)) {
            this.killChathead();
            this.enteredBackgroundAt = System.currentTimeMillis();
            this.hasBeenBackgrounded = true;
        } else {
            this.detachActivity(activity);
        }
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

