/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Transformation;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.transforms.RoundTransform;

public class AvatarUtils {
    public static void createAvatar(Avatar avatar, ImageView imageView, Context context) {
        if (!avatar.getImage_url().isEmpty()) {
            Picasso.with((Context)context).load(avatar.getImage_url()).placeholder(R.drawable.intercomsdk_avatar).error(R.drawable.intercomsdk_avatar).transform((Transformation)new RoundTransform()).into(imageView);
        } else if (!avatar.getInitials().isEmpty()) {
            imageView.setImageBitmap(AvatarUtils.getTextBitmap(avatar.getInitials(), Bridge.getIdentityStore().getAppConfig().getBaseColor(), context));
        } else {
            imageView.setImageBitmap(BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.intercomsdk_avatar));
        }
    }

    public static Bitmap getTextBitmap(String initials, String color2, Context context) {
        int w = 128;
        int h = 128;
        Bitmap.Config conf = Bitmap.Config.ARGB_8888;
        Bitmap output = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)conf);
        int bgColor = Color.parseColor((String)context.getResources().getString(R.color.intercomsdk_main_blue));
        if (!color2.isEmpty()) {
            bgColor = color2.startsWith("#") ? Color.parseColor((String)color2) : Color.parseColor((String)("#" + color2));
        }
        output.eraseColor(bgColor);
        Bitmap roundedBitmap = AvatarUtils.getRoundedBitmap(output);
        Canvas c = new Canvas(roundedBitmap);
        Paint paint = new Paint(1);
        paint.setColor(-1);
        float scale = context.getResources().getDisplayMetrics().density;
        paint.setTextSize((float)((int)(20.0f * scale)));
        Rect bounds = new Rect();
        paint.getTextBounds(initials, 0, initials.length(), bounds);
        int x = (roundedBitmap.getWidth() - bounds.width()) / 2;
        int y = (roundedBitmap.getHeight() + bounds.height()) / 2;
        c.drawText(initials, (float)x, (float)y, paint);
        return roundedBitmap;
    }

    public static Bitmap getRoundedBitmap(Bitmap bitmap) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawCircle((float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), (float)(bitmap.getWidth() / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return Bitmap.createScaledBitmap((Bitmap)output, (int)128, (int)128, (boolean)false);
    }
}

