/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.adapters.ConversationAdapter;
import io.intercom.android.sdk.conversation.BaseConversationFragment;
import io.intercom.android.sdk.interfaces.OnSmallAnnouncementInteractionListener;
import io.intercom.android.sdk.models.APIModels.Part;
import io.intercom.android.sdk.models.Events.ReadEvent;
import io.intercom.android.sdk.models.LWR;
import io.intercom.android.sdk.utilities.ScreenUtils;
import io.intercom.android.sdk.views.LockableScrollView;
import io.intercom.blocks.Blocks;

@TargetApi(value=15)
public class SmallAnnouncementFragment
extends BaseConversationFragment
implements View.OnClickListener {
    private static final String ARG_CONVERSATION_ID = "conversationArg";
    private static final String ARG_PART = "partArg";
    private static final int SMALL_ANNOUNCEMENT_OFFSET_DP = 35;
    private static final int LWR_TOUCH_AREA_DP = 73;
    private static final int TOUCH_BUFFER_DP = 26;
    private static final int MAX_PARAGRAPH_HEIGHT = 355;
    private OnSmallAnnouncementInteractionListener mListener;
    private Part smallAnnouncement;
    private View rootView;

    public static SmallAnnouncementFragment newInstance(String conversationId, Part part) {
        SmallAnnouncementFragment fragment = new SmallAnnouncementFragment();
        Bundle args = new Bundle();
        args.putString(ARG_CONVERSATION_ID, conversationId);
        args.putParcelable(ARG_PART, (Parcelable)part);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mListener = (OnSmallAnnouncementInteractionListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnSmallAnnouncementInteractionListener");
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.smallAnnouncement = (Part)args.getParcelable(ARG_PART);
            this.conversationId = args.getString(ARG_CONVERSATION_ID);
            this.conversationParts.add(this.smallAnnouncement);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercomsdk_fragment_small_announcement, container, false);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.finalRowOffset = Bridge.getIdentityStore().getAppConfig().isShowPoweredBy() ? 1 : 0;
        this.blocks = new Blocks((Context)this.getActivity());
        ImageButton closeButton = (ImageButton)this.rootView.findViewById(R.id.close_button);
        closeButton.setOnClickListener((View.OnClickListener)this);
        this.adapter = new ConversationAdapter((Context)this.getActivity(), R.layout.intercomsdk_row_user_part, this.conversationParts);
        this.displaySmallAnnouncement();
        return this.rootView;
    }

    private void displaySmallAnnouncement() {
        this.rootView.setOnClickListener((View.OnClickListener)this);
        this.rootView.findViewById(R.id.transitionOverlay).setOnClickListener((View.OnClickListener)this);
        this.createMessageUI(this.smallAnnouncement);
        ImageButton closeButton = (ImageButton)this.rootView.findViewById(R.id.close_button);
        closeButton.setOnClickListener((View.OnClickListener)this);
        final LockableScrollView containerView = (LockableScrollView)this.rootView.findViewById(R.id.announcement);
        final View view = this.adapter.getBlockView(0, null, (ViewGroup)containerView);
        containerView.setScrollingEnabled(false);
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                view.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        SmallAnnouncementFragment.this.addBottomBorder(SmallAnnouncementFragment.this.smallAnnouncement, containerView, view);
                    }
                });
                SmallAnnouncementFragment.this.addBottomBorder(SmallAnnouncementFragment.this.smallAnnouncement, containerView, view);
            }
        });
        containerView.addView(view);
        this.markAsRead();
        Bridge.getBus().post((Object)new ReadEvent(this.conversationId));
    }

    private void addBottomBorder(Part smallAnnouncement, LockableScrollView containerView, final View messageView) {
        ((LinearLayout)messageView.findViewById(R.id.cellLayout)).getChildAt(0).getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                View blockView = ((LinearLayout)messageView.findViewById(R.id.cellLayout)).getChildAt(0);
                if (Build.VERSION.SDK_INT >= 16) {
                    blockView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    blockView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                int pixels = (int)ScreenUtils.convertDpToPixel(355.0f, (Context)SmallAnnouncementFragment.this.getActivity());
                if (blockView.getHeight() > pixels) {
                    LinearLayout.LayoutParams p = (LinearLayout.LayoutParams)blockView.getLayoutParams();
                    p.height = pixels;
                    blockView.setLayoutParams((ViewGroup.LayoutParams)p);
                    blockView.invalidate();
                }
            }
        });
        View fadeView = this.rootView.findViewById(R.id.white_fade);
        if (fadeView.getVisibility() != 0) {
            float heightInDP = ScreenUtils.convertPixelsToDp(messageView.getHeight(), (Context)this.getActivity());
            View conversationInterceptor = this.rootView.findViewById(R.id.transitionOverlay);
            conversationInterceptor.getLayoutParams().height = messageView.getHeight();
            float containerHeightInDP = ScreenUtils.convertPixelsToDp(containerView.getHeight(), (Context)this.getActivity());
            if (heightInDP - 35.0f > containerHeightInDP) {
                conversationInterceptor.setVisibility(0);
                conversationInterceptor.getLayoutParams().height = (int)((float)containerView.getHeight() + ScreenUtils.convertDpToPixel(26.0f, (Context)this.getActivity()));
                messageView.findViewById(R.id.buttonLayout).bringToFront();
                View.OnTouchListener listener = new View.OnTouchListener(){

                    public boolean onTouch(View view, MotionEvent motionEvent) {
                        return false;
                    }
                };
                fadeView.setOnTouchListener(listener);
                View roundBottom = this.rootView.findViewById(R.id.round_bottom);
                roundBottom.setOnTouchListener(listener);
                fadeView.setVisibility(0);
                roundBottom.setVisibility(0);
            } else if (smallAnnouncement.getLightweightReply() instanceof LWR.NullLWR) {
                conversationInterceptor.setVisibility(0);
                conversationInterceptor.getLayoutParams().height = (int)((float)conversationInterceptor.getLayoutParams().height + ScreenUtils.convertDpToPixel(13.0f, (Context)this.getActivity()));
            } else {
                conversationInterceptor.getLayoutParams().height = (int)((float)conversationInterceptor.getLayoutParams().height - ScreenUtils.convertDpToPixel(73.0f, (Context)this.getActivity()));
            }
        }
        containerView.scrollTo(0, 0);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.transitionOverlay) {
            this.transitionToFullConversation();
        } else if (v.getId() == R.id.close_button || v.getId() == R.id.announcementRootView) {
            this.closeTapped();
        }
    }

    private void transitionToFullConversation() {
        this.mListener.transitionToConversation(this.conversationId);
    }
}

