/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.content.Context;
import android.content.Intent;
import com.squareup.otto.Bus;
import com.squareup.otto.ThreadEnforcer;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.MainThreadBus;
import io.intercom.android.sdk.api.PollingManager;
import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.preview.PreviewService;

public class Bridge {
    private static Bridge instance;
    private final PollingManager poller;
    private final MainThreadBus bus;
    private final Api api;
    private final IdentityStore identityStore;
    private final Context appContext;
    private NexusWrapper nexusClient;
    private boolean hasPinged = false;

    private Bridge(Context appContext) {
        this.appContext = appContext.getApplicationContext();
        this.poller = new PollingManager();
        this.bus = new MainThreadBus(ThreadEnforcer.ANY);
        this.api = new Api(appContext, this.bus);
        this.identityStore = new IdentityStore(appContext);
    }

    public static synchronized void init(Context context) {
        if (instance == null) {
            Logger.INTERNAL("bridge", "initialising bridge");
            instance = new Bridge(context);
        }
    }

    public static Api getApi() {
        return Bridge.instance.api;
    }

    public static Bus getBus() {
        return Bridge.instance.bus;
    }

    public static PollingManager getPoller() {
        return Bridge.instance.poller;
    }

    public static IdentityStore getIdentityStore() {
        return Bridge.instance.identityStore;
    }

    public static NexusWrapper getNexusClient() {
        if (Bridge.instance.nexusClient == null) {
            Bridge.instance.nexusClient = new NexusWrapper();
            Bridge.instance.nexusClient.setLoggingEnabled(false);
        }
        return Bridge.instance.nexusClient;
    }

    public static Context getContext() {
        return Bridge.instance.appContext;
    }

    public static void pingAndLaunchChathead() {
        if (instance != null) {
            instance.ping();
        }
    }

    private void ping() {
        if (!this.hasPinged) {
            this.api.ping();
            this.appContext.startService(new Intent(this.appContext, PreviewService.class));
            this.hasPinged = true;
        }
    }
}

